/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.cluster;

import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import com.liferay.portal.kernel.cluster.NullClusterable;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class ClusterableAdvice
extends AnnotationChainableMethodAdvice<Clusterable> {
    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == NullClusterable.NULL_CLUSTERABLE) {
            return;
        }
        ClusterableInvokerUtil.invokeOnCluster((Class)clusterable.acceptor(), (Object)methodInvocation.getThis(), (Method)methodInvocation.getMethod(), (Object[])methodInvocation.getArguments());
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return null;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == NullClusterable.NULL_CLUSTERABLE) {
            return null;
        }
        if (!clusterable.onMaster()) {
            return null;
        }
        Object result = null;
        result = ClusterMasterExecutorUtil.isMaster() ? methodInvocation.proceed() : ClusterableInvokerUtil.invokeOnMaster((Class)clusterable.acceptor(), (Object)methodInvocation.getThis(), (Method)methodInvocation.getMethod(), (Object[])methodInvocation.getArguments());
        Method method = methodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            result = this.nullResult;
        }
        return result;
    }

    @Override
    public Clusterable getNullAnnotation() {
        return NullClusterable.NULL_CLUSTERABLE;
    }
}

