/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONRPCResponse;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.NameValue;
import jodd.util.ReflectUtil;

public class JSONWebServiceActionImpl
implements JSONWebServiceAction {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceActionImpl.class);
    private final JSONWebServiceActionConfig _jsonWebServiceActionConfig;
    private final JSONWebServiceActionParameters _jsonWebServiceActionParameters;
    private final JSONWebServiceNaming _jsonWebServiceNaming;

    public JSONWebServiceActionImpl(JSONWebServiceActionConfig jsonWebServiceActionConfig, JSONWebServiceActionParameters jsonWebServiceActionParameters, JSONWebServiceNaming jsonWebServiceNaming) {
        this._jsonWebServiceActionConfig = jsonWebServiceActionConfig;
        this._jsonWebServiceActionParameters = jsonWebServiceActionParameters;
        this._jsonWebServiceNaming = jsonWebServiceNaming;
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return this._jsonWebServiceActionConfig;
    }

    public Object invoke() throws Exception {
        JSONRPCRequest jsonRPCRequest = this._jsonWebServiceActionParameters.getJSONRPCRequest();
        if (jsonRPCRequest == null) {
            return this._invokeActionMethod();
        }
        Object result = null;
        Exception exception = null;
        try {
            result = this._invokeActionMethod();
        }
        catch (Exception e) {
            exception = e;
            _log.error((Object)e, (Throwable)e);
        }
        return new JSONRPCResponse(jsonRPCRequest, result, exception);
    }

    private Object _convertListToArray(List<?> list, Class<?> componentType) {
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object entry = list.get(i);
            if (entry != null) {
                entry = this._convertType(entry, componentType);
            }
            Array.set(array, i, entry);
        }
        return array;
    }

    private Object _convertType(Object inputObject, Class<?> targetType) {
        if (targetType == null) {
            return inputObject;
        }
        Object outputObject = null;
        try {
            outputObject = TypeConverterManager.convertType((Object)inputObject, targetType);
        }
        catch (TypeConversionException tce) {
            if (inputObject instanceof Map) {
                try {
                    if (targetType.isInterface()) {
                        Class<?> clazz = this.getClass();
                        ClassLoader classLoader = clazz.getClassLoader();
                        String modelClassName = this._jsonWebServiceNaming.convertModelClassToImplClassName(targetType);
                        try {
                            targetType = classLoader.loadClass(modelClassName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    outputObject = targetType.newInstance();
                    BeanCopy beanCopy = BeanCopy.beans((Object)inputObject, (Object)outputObject);
                    beanCopy.copy();
                    return outputObject;
                }
                catch (Exception e) {
                    throw new TypeConversionException((Throwable)e);
                }
            }
            throw tce;
        }
        return outputObject;
    }

    private Object _convertValueToParameterValue(Object value, Class<?> parameterType, Class<?>[] genericParameterTypes) {
        if (parameterType.isArray()) {
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = "[".concat(valueString).concat("]");
                }
                list = (List)JSONFactoryUtil.looseDeserialize((String)valueString, ArrayList.class);
            }
            return this._convertListToArray(list, parameterType.getComponentType());
        }
        if (parameterType.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            String valueString = value.toString();
            valueString = valueString.trim();
            long timeInMillis = GetterUtil.getLong((String)valueString);
            calendar.setTimeInMillis(timeInMillis);
            return calendar;
        }
        if (Collection.class.isAssignableFrom(parameterType)) {
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = "[".concat(valueString).concat("]");
                }
                list = (List)JSONFactoryUtil.looseDeserialize((String)valueString, ArrayList.class);
            }
            return this._generifyList(list, genericParameterTypes);
        }
        if (parameterType.equals(Locale.class)) {
            String valueString = value.toString();
            valueString = valueString.trim();
            return LocaleUtil.fromLanguageId((String)valueString);
        }
        if (parameterType.equals(Map.class)) {
            Map map = null;
            if (value instanceof Map) {
                map = (Map)value;
            } else {
                String valueString = value.toString();
                valueString = valueString.trim();
                map = (Map)JSONFactoryUtil.looseDeserialize((String)valueString, HashMap.class);
            }
            return this._generifyMap(map, genericParameterTypes);
        }
        Object parameterValue = null;
        try {
            parameterValue = this._convertType(value, parameterType);
        }
        catch (Exception e1) {
            if (value instanceof Map) {
                try {
                    parameterValue = this._createDefaultParameterValue(null, parameterType);
                }
                catch (Exception e2) {
                    ClassCastException cce = new ClassCastException(e1.getMessage());
                    cce.addSuppressed(e2);
                    throw cce;
                }
                BeanCopy beanCopy = BeanCopy.beans((Object)value, (Object)parameterValue);
                beanCopy.copy();
            }
            String valueString = value.toString();
            if (!(valueString = valueString.trim()).startsWith("{")) {
                throw new ClassCastException(e1.getMessage());
            }
            parameterValue = JSONFactoryUtil.looseDeserialize((String)valueString, parameterType);
        }
        return parameterValue;
    }

    private Object _createDefaultParameterValue(String parameterName, Class<?> parameterType) throws Exception {
        if (parameterName != null && parameterName.equals("serviceContext") && parameterType.equals(ServiceContext.class)) {
            ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            return serviceContext;
        }
        String className = parameterType.getName();
        if (className.contains("com.liferay") && className.contains("Util")) {
            throw new IllegalArgumentException("Not instantiating " + className);
        }
        return parameterType.newInstance();
    }

    private List<?> _generifyList(List<?> list, Class<?>[] types) {
        if (types == null) {
            return list;
        }
        if (types.length != 1) {
            return list;
        }
        ArrayList newList = new ArrayList(list.size());
        for (Object entry : list) {
            if (entry != null) {
                entry = this._convertType(entry, types[0]);
            }
            newList.add(entry);
        }
        return newList;
    }

    private Map<?, ?> _generifyMap(Map<?, ?> map, Class<?>[] types) {
        if (types == null) {
            return map;
        }
        if (types.length != 2) {
            return map;
        }
        HashMap newMap = new HashMap(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = this._convertType(entry.getKey(), types[0]);
            Object value = entry.getValue();
            if (value != null) {
                value = this._convertType(value, types[1]);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private void _injectInnerParametersIntoValue(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            return;
        }
        List<NameValue<String, Object>> innerParameters = this._jsonWebServiceActionParameters.getInnerParameters(parameterName);
        if (innerParameters == null) {
            return;
        }
        for (NameValue<String, Object> innerParameter : innerParameters) {
            try {
                BeanUtil.setProperty((Object)parameterValue, (String)((String)innerParameter.getName()), (Object)innerParameter.getValue());
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to set inner parameter ", parameterName, ".", (String)innerParameter.getName()}), (Throwable)e);
            }
        }
    }

    private Object _invokeActionMethod() throws Exception {
        Object actionObject = this._jsonWebServiceActionConfig.getActionObject();
        Method actionMethod = this._jsonWebServiceActionConfig.getActionMethod();
        Class<?> actionClass = this._jsonWebServiceActionConfig.getActionClass();
        Object[] parameters = this._prepareParameters(actionClass);
        if (this._jsonWebServiceActionConfig.isDeprecated() && _log.isWarnEnabled()) {
            _log.warn((Object)("Invoking deprecated method " + actionMethod.getName()));
        }
        return actionMethod.invoke(actionObject, parameters);
    }

    private Object[] _prepareParameters(Class<?> actionClass) throws Exception {
        MethodParameter[] methodParameters = this._jsonWebServiceActionConfig.getMethodParameters();
        Object[] parameters = new Object[methodParameters.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            String parameterName = methodParameters[i].getName();
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            Object value = this._jsonWebServiceActionParameters.getParameter(parameterName);
            Object parameterValue = null;
            if (value != null) {
                ClassLoader classLoader;
                Class<?> parameterType = methodParameters[i].getType();
                String parameterTypeName = this._jsonWebServiceActionParameters.getParameterTypeName(parameterName);
                if (parameterTypeName != null && !ReflectUtil.isTypeOf(parameterType = (classLoader = actionClass.getClassLoader()).loadClass(parameterTypeName), (Class)methodParameters[i].getType())) {
                    throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unmatched argument type ", parameterType.getName(), " for method argument ", String.valueOf(i)}));
                }
                if (value.equals(Void.TYPE)) {
                    parameterValue = this._createDefaultParameterValue(parameterName, parameterType);
                } else {
                    parameterValue = this._convertValueToParameterValue(value, parameterType, methodParameters[i].getGenericTypes());
                    ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
                    if (serviceContext != null && parameterName.equals("serviceContext")) {
                        if (parameterValue != null && parameterValue instanceof ServiceContext) {
                            serviceContext.merge((ServiceContext)parameterValue);
                        }
                        parameterValue = serviceContext;
                    }
                }
            }
            this._injectInnerParametersIntoValue(parameterName, parameterValue);
            parameters[i] = parameterValue;
        }
        return parameters;
    }
}

