/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceContextAdvice
extends ChainableMethodAdvice {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        int index = this._getServiceContextParameterIndex(methodInvocation.getMethod());
        if (index < 0) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return methodInvocation.proceed();
        }
        Object[] arguments = methodInvocation.getArguments();
        ServiceContext serviceContext = (ServiceContext)arguments[index];
        if (serviceContext != null) {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            if (serviceContext != null) {
                ServiceContextThreadLocal.popServiceContext();
            }
        }
    }

    @Deprecated
    protected boolean hasServiceContextParameter(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = parameterTypes.length - 1; i >= 0; --i) {
            if (!ServiceContext.class.isAssignableFrom(parameterTypes[i])) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean pushServiceContext(MethodInvocation methodInvocation) {
        Object[] arguments = methodInvocation.getArguments();
        if (arguments == null) {
            return false;
        }
        for (int i = arguments.length - 1; i >= 0; --i) {
            if (!(arguments[i] instanceof ServiceContext)) continue;
            ServiceContext serviceContext = (ServiceContext)arguments[i];
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            return true;
        }
        return false;
    }

    private int _getServiceContextParameterIndex(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = parameterTypes.length - 1; i >= 0; --i) {
            if (!ServiceContext.class.isAssignableFrom(parameterTypes[i])) continue;
            return i;
        }
        return -1;
    }
}

