/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.template.ClassLoaderTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.CacheTemplateResource;
import com.liferay.portal.template.ClassLoaderResourceParser;
import com.liferay.portal.template.TemplateResourceParser;
import com.liferay.portal.template.TemplateResourcePortalCacheListener;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@DoPrivileged
public class DefaultTemplateResourceLoader
implements TemplateResourceLoader {
    private static final Log _log = LogFactoryUtil.getLog(DefaultTemplateResourceLoader.class);
    private static final NullHolderTemplateResource _nullHolderTemplateResource = new NullHolderTemplateResource();
    private long _modificationCheckInterval;
    private final MultiVMPool _multiVMPool;
    private final PortalCache<String, TemplateResource> _multiVMPortalCache;
    private final String _name;
    private final SingleVMPool _singleVMPool;
    private final PortalCache<String, TemplateResource> _singleVMPortalCache;
    private final ServiceTrackerList<TemplateResourceParser> _templateResourceParsers;

    public DefaultTemplateResourceLoader(String name, long modificationCheckInterval, MultiVMPool multiVMPool, SingleVMPool singleVMPool) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException("Template resource loader name is null");
        }
        this._name = name;
        this._templateResourceParsers = ServiceTrackerCollections.openList(TemplateResourceParser.class, (String)("(lang.type=" + this._name + ")"));
        this._modificationCheckInterval = modificationCheckInterval;
        this._multiVMPool = multiVMPool;
        String portalCacheName = TemplateResourceLoader.class.getName();
        portalCacheName = portalCacheName.concat(".").concat(name);
        this._multiVMPortalCache = this._multiVMPool.getPortalCache(portalCacheName);
        TemplateResourcePortalCacheListener cacheListener = new TemplateResourcePortalCacheListener(name);
        this._multiVMPortalCache.registerPortalCacheListener((PortalCacheListener)cacheListener, PortalCacheListenerScope.ALL);
        this._singleVMPool = singleVMPool;
        this._singleVMPortalCache = this._singleVMPool.getPortalCache(portalCacheName);
        this._singleVMPortalCache.registerPortalCacheListener((PortalCacheListener)cacheListener, PortalCacheListenerScope.ALL);
    }

    @Deprecated
    public DefaultTemplateResourceLoader(String name, String[] templateResourceParserClassNames, long modificationCheckInterval, MultiVMPool multiVMPool, SingleVMPool singleVMPool) {
        this(name, modificationCheckInterval, multiVMPool, singleVMPool);
    }

    public void clearCache() {
        this._multiVMPortalCache.removeAll();
        this._singleVMPortalCache.removeAll();
    }

    public void clearCache(String templateId) {
        this._multiVMPortalCache.remove((Serializable)((Object)templateId));
        this._singleVMPortalCache.remove((Serializable)((Object)templateId));
    }

    public void destroy() {
        this._multiVMPool.removePortalCache(this._multiVMPortalCache.getPortalCacheName());
        this._singleVMPool.removePortalCache(this._singleVMPortalCache.getPortalCacheName());
        this._templateResourceParsers.close();
    }

    public String getName() {
        return this._name;
    }

    public TemplateResource getTemplateResource(String templateId) {
        if (this._modificationCheckInterval == 0L) {
            return this._loadFromParser(templateId);
        }
        TemplateResource templateResource = this._loadFromCache(templateId);
        if (templateResource != null) {
            if (templateResource instanceof NullHolderTemplateResource) {
                return null;
            }
            return templateResource;
        }
        templateResource = this._loadFromParser(templateId);
        this._updateCache(templateId, templateResource);
        return templateResource;
    }

    public boolean hasTemplateResource(String templateId) {
        TemplateResource templateResource = this.getTemplateResource(templateId);
        return templateResource != null;
    }

    private TemplateResource _getTemplateResource() {
        TemplateResource templateResource = TemplateResourceThreadLocal.getTemplateResource(this._name);
        if (templateResource instanceof CacheTemplateResource) {
            CacheTemplateResource cacheTemplateResource = (CacheTemplateResource)templateResource;
            return cacheTemplateResource.getInnerTemplateResource();
        }
        return templateResource;
    }

    private Set<TemplateResourceParser> _getTemplateResourceParsers() {
        TemplateResource templateResource = this._getTemplateResource();
        if (templateResource != null && templateResource instanceof ClassLoaderTemplateResource) {
            ClassLoaderTemplateResource classLoaderTemplateResource = (ClassLoaderTemplateResource)templateResource;
            ClassLoaderResourceParser classLoaderResourceParser = new ClassLoaderResourceParser(classLoaderTemplateResource.getClassLoader());
            HashSet<TemplateResourceParser> templateResourceParsers = new HashSet<TemplateResourceParser>((Collection<TemplateResourceParser>)this._templateResourceParsers);
            templateResourceParsers.add(classLoaderResourceParser);
            return templateResourceParsers;
        }
        return new HashSet<TemplateResourceParser>((Collection<TemplateResourceParser>)this._templateResourceParsers);
    }

    private TemplateResource _loadFromCache(PortalCache<String, TemplateResource> portalCache, String templateId) {
        Object object = portalCache.get((Serializable)((Object)templateId));
        if (object == null) {
            return null;
        }
        if (!(object instanceof TemplateResource)) {
            portalCache.remove((Serializable)((Object)templateId));
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Remove template " + templateId + " because it is not a template resource"));
            }
            return null;
        }
        TemplateResource templateResource = (TemplateResource)object;
        if (this._modificationCheckInterval > 0L) {
            long expireTime = templateResource.getLastModified() + this._modificationCheckInterval;
            if (System.currentTimeMillis() > expireTime) {
                portalCache.remove((Serializable)((Object)templateId));
                templateResource = _nullHolderTemplateResource;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Remove expired template resource " + templateId));
                }
            }
        }
        return templateResource;
    }

    private TemplateResource _loadFromCache(String templateId) {
        TemplateResource templateResource = this._loadFromCache(this._singleVMPortalCache, templateId);
        if (templateResource != null) {
            if (templateResource == _nullHolderTemplateResource) {
                return null;
            }
            return templateResource;
        }
        templateResource = this._loadFromCache(this._multiVMPortalCache, templateId);
        if (templateResource == null || templateResource == _nullHolderTemplateResource) {
            return null;
        }
        return templateResource;
    }

    private TemplateResource _loadFromParser(String templateId) {
        Set<TemplateResourceParser> templateResourceParsers = this._getTemplateResourceParsers();
        for (TemplateResourceParser templateResourceParser : templateResourceParsers) {
            try {
                TemplateResource templateResource;
                if (!templateResourceParser.isTemplateResourceValid(templateId, this.getName()) || (templateResource = templateResourceParser.getTemplateResource(templateId)) == null) continue;
                if (this._modificationCheckInterval != 0L) {
                    templateResource = new CacheTemplateResource(templateResource);
                }
                return templateResource;
            }
            catch (TemplateException te) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to parse template ", templateId, " with parser ", String.valueOf(templateResourceParser)}), (Throwable)te);
            }
        }
        return null;
    }

    private void _updateCache(String templateId, TemplateResource templateResource) {
        if (templateResource == null) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)new NullHolderTemplateResource());
            return;
        }
        CacheTemplateResource cacheTemplateResource = (CacheTemplateResource)templateResource;
        TemplateResource innerTemplateResource = cacheTemplateResource.getInnerTemplateResource();
        if (innerTemplateResource instanceof URLTemplateResource) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)templateResource);
            return;
        }
        this._multiVMPortalCache.put((Serializable)((Object)templateId), (Object)templateResource);
    }

    private static class NullHolderTemplateResource
    implements TemplateResource {
        private long _lastModified = System.currentTimeMillis();

        public long getLastModified() {
            return this._lastModified;
        }

        public Reader getReader() {
            return null;
        }

        public String getTemplateId() {
            return null;
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this._lastModified = objectInput.readLong();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeLong(this._lastModified);
        }
    }
}

