/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyMySQL
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyMySQL.class);

    @Override
    protected void doVerify() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MARIADB || db.getDBType() == DBType.MYSQL) {
            this.verifyTableEngine();
        }
    }

    protected void verifyTableEngine() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery("show table status");){
            while (rs.next()) {
                String tableName = rs.getString("Name");
                if (!this.isPortalTableName(tableName)) continue;
                String engine = GetterUtil.getString((String)rs.getString("Engine"));
                String comment = GetterUtil.getString((String)rs.getString("Comment"));
                if (StringUtil.equalsIgnoreCase((String)comment, (String)"VIEW") || StringUtil.equalsIgnoreCase((String)engine, (String)PropsValues.DATABASE_MYSQL_ENGINE)) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Updating table ", tableName, " to use engine ", PropsValues.DATABASE_MYSQL_ENGINE}));
                }
                statement.executeUpdate(StringBundler.concat((String[])new String[]{"alter table ", tableName, " engine ", PropsValues.DATABASE_MYSQL_ENGINE}));
            }
        }
    }
}

