/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        this.verifyGroup(webDAVRequest);
        String path = this.getRootPath() + webDAVRequest.getPath();
        return new BaseResourceImpl(path, "", "");
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        this.verifyGroup(webDAVRequest);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String path = this.getRootPath() + webDAVRequest.getPath();
        for (String token : WebDAVUtil.getStorageTokens()) {
            resources.add((Resource)new BaseResourceImpl(path, token, token));
        }
        return resources;
    }

    protected void verifyGroup(WebDAVRequest webDAVRequest) throws WebDAVException {
        String path = webDAVRequest.getPath();
        try {
            long userId = webDAVRequest.getUserId();
            List groups = WebDAVUtil.getGroups((long)userId);
            for (Group group : groups) {
                if (!path.equals(group.getFriendlyURL())) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new WebDAVException("Invalid group for given credentials " + webDAVRequest.getRootPath() + path);
    }
}

