/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.AssetCategoryNameException;
import com.liferay.asset.kernel.exception.DuplicateCategoryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetCategoryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.util.comparator.AssetCategoryLeftCategoryIdComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

public class AssetCategoryLocalServiceImpl
extends AssetCategoryLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory addCategory(long userId, long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        this.validate(0L, parentCategoryId, name, vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        long categoryId = this.counterLocalService.increment();
        AssetCategory category = this.assetCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        category.setVocabularyId(vocabularyId);
        this.assetCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getModelPermissions());
        }
        return category;
    }

    public AssetCategory addCategory(long userId, long groupId, String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        return this.assetCategoryLocalService.addCategory(userId, groupId, 0L, titleMap, descriptionMap, vocabularyId, null, serviceContext);
    }

    public void addCategoryResources(AssetCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(AssetCategory category, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), modelPermissions);
    }

    public void deleteCategories(List<AssetCategory> categories) throws PortalException {
        ArrayList<Long> rebuildTreeGroupIds = new ArrayList<Long>();
        for (AssetCategory category : categories) {
            if (!rebuildTreeGroupIds.contains(category.getGroupId()) && this.getChildCategoriesCount(category.getCategoryId()) > 0) {
                final long groupId = category.getGroupId();
                TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        AssetCategoryLocalServiceImpl.this.assetCategoryLocalService.rebuildTree(groupId, true);
                        return null;
                    }
                });
                rebuildTreeGroupIds.add(groupId);
            }
            this.assetCategoryLocalService.deleteCategory(category, true);
        }
    }

    public void deleteCategories(long[] categoryIds) throws PortalException {
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>();
        for (long categoryId : categoryIds) {
            AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
            categories.add(category);
        }
        this.deleteCategories(categories);
    }

    public AssetCategory deleteCategory(AssetCategory category) throws PortalException {
        return this.assetCategoryLocalService.deleteCategory(category, false);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public AssetCategory deleteCategory(AssetCategory category, boolean skipRebuildTree) throws PortalException {
        List categories = this.assetCategoryPersistence.findByParentCategoryId(category.getCategoryId());
        for (AssetCategory curCategory : categories) {
            this.assetCategoryLocalService.deleteCategory(curCategory, true);
        }
        if (!categories.isEmpty() && !skipRebuildTree) {
            final long groupId = category.getGroupId();
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AssetCategoryLocalServiceImpl.this.assetCategoryLocalService.rebuildTree(groupId, true);
                    return null;
                }
            });
        }
        List entries = this.assetCategoryPersistence.getAssetEntries(category.getCategoryId());
        this.assetCategoryPersistence.remove((BaseModel)category);
        this.resourceLocalService.deleteResource(category.getCompanyId(), AssetCategory.class.getName(), 4, category.getCategoryId());
        this.assetEntryLocalService.reindex(entries);
        return category;
    }

    public AssetCategory deleteCategory(long categoryId) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        return this.assetCategoryLocalService.deleteCategory(category);
    }

    public void deleteVocabularyCategories(long vocabularyId) throws PortalException {
        List categories = this.assetCategoryPersistence.findByP_V(0L, vocabularyId, -1, -1, (OrderByComparator)new AssetCategoryLeftCategoryIdComparator(false));
        this.assetCategoryLocalService.deleteCategories(categories);
    }

    public AssetCategory fetchCategory(long categoryId) {
        return this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
    }

    public AssetCategory fetchCategory(long groupId, long parentCategoryId, String name, long vocabularyId) {
        return this.assetCategoryPersistence.fetchByG_P_N_V_First(groupId, parentCategoryId, name, vocabularyId, null);
    }

    public List<AssetCategory> getCategories() {
        return this.assetCategoryPersistence.findAll();
    }

    public List<AssetCategory> getCategories(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(documents.size());
        for (Document document : documents) {
            long categoryId = GetterUtil.getLong((String)document.get("assetCategoryId"));
            AssetCategory category = this.fetchCategory(categoryId);
            if (category == null) {
                categories = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetCategory.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (categories == null) continue;
            categories.add(category);
        }
        return categories;
    }

    @ThreadLocalCachable
    public List<AssetCategory> getCategories(long classNameId, long classPK) {
        return this.assetCategoryFinder.findByC_C(classNameId, classPK);
    }

    public List<AssetCategory> getCategories(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getCategories(classNameId, classPK);
    }

    public AssetCategory getCategory(long categoryId) throws PortalException {
        return this.assetCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public AssetCategory getCategory(String uuid, long groupId) throws PortalException {
        return this.assetCategoryPersistence.findByUUID_G(uuid, groupId);
    }

    public long[] getCategoryIds(String className, long classPK) {
        return this.getCategoryIds(this.getCategories(className, classPK));
    }

    public String[] getCategoryNames() {
        return this.getCategoryNames(this.getCategories());
    }

    public String[] getCategoryNames(long classNameId, long classPK) {
        return this.getCategoryNames(this.getCategories(classNameId, classPK));
    }

    public String[] getCategoryNames(String className, long classPK) {
        return this.getCategoryNames(this.getCategories(className, classPK));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId, start, end, obc);
    }

    public int getChildCategoriesCount(long parentCategoryId) {
        return this.assetCategoryPersistence.countByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getDescendantCategories(AssetCategory category) {
        return this.assetCategoryPersistence.getDescendants(category);
    }

    public List<AssetCategory> getEntryCategories(long entryId) {
        return this.assetEntryPersistence.getAssetCategories(entryId);
    }

    public List<Long> getSubcategoryIds(long parentCategoryId) {
        AssetCategory parentAssetCategory = this.assetCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentAssetCategory == null) {
            return Collections.emptyList();
        }
        return ListUtil.toList((List)this.assetCategoryPersistence.getDescendants(parentAssetCategory), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    public long[] getViewableCategoryIds(String className, long classPK, long[] categoryIds) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return categoryIds;
        }
        List oldCategories = this.assetCategoryLocalService.getCategories(className, classPK);
        for (AssetCategory category : oldCategories) {
            if (ArrayUtil.contains((long[])categoryIds, (long)category.getCategoryId()) || AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            categoryIds = ArrayUtil.append((long[])categoryIds, (long)category.getCategoryId());
        }
        return categoryIds;
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByVocabularyId(vocabularyId, start, end, obc);
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByP_V(parentCategoryId, vocabularyId, start, end, obc);
    }

    public int getVocabularyCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByVocabularyId(vocabularyId);
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.getVocabularyCategories(0L, vocabularyId, start, end, obc);
    }

    public int getVocabularyRootCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByP_V(0L, vocabularyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory mergeCategories(long fromCategoryId, long toCategoryId) throws PortalException {
        List entries = this.assetCategoryPersistence.getAssetEntries(fromCategoryId);
        this.assetCategoryPersistence.addAssetEntries(toCategoryId, entries);
        this.assetCategoryLocalService.deleteCategory(fromCategoryId);
        return this.getCategory(toCategoryId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        this.validate(categoryId, parentCategoryId, category.getName(), vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        if (vocabularyId != category.getVocabularyId()) {
            this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            category.setVocabularyId(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
        }
        category.setParentCategoryId(parentCategoryId);
        this.assetCategoryPersistence.update((BaseModel)category);
        return category;
    }

    public void rebuildTree(long groupId, boolean force) {
        this.assetCategoryPersistence.rebuildTree(groupId, force);
    }

    public List<AssetCategory> search(long groupId, String name, String[] categoryProperties, int start, int end) {
        return this.assetCategoryFinder.findByG_N_P(groupId, name, categoryProperties, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long groupIds, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategories(companyId, new long[]{groupIds}, title, new long[]{vocabularyId}, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, new long[0], vocabularyIds, start, end, null);
        return this.searchCategories(searchContext);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, parentCategoryIds, vocabularyIds, start, end, null);
        return this.searchCategories(searchContext);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] vocabularyIds, long[] parentCategoryIds, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, parentCategoryIds, vocabularyIds, start, end, sort);
        return this.searchCategories(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory updateCategory(long userId, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        this.validate(categoryId, parentCategoryId, name, vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        String oldName = category.getName();
        if (vocabularyId != category.getVocabularyId()) {
            this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            parentCategoryId = 0L;
            category.setVocabularyId(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
        }
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        this.assetCategoryPersistence.update((BaseModel)category);
        if (!oldName.equals(name)) {
            List entries = this.assetCategoryPersistence.getAssetEntries(category.getCategoryId());
            this.assetEntryLocalService.reindex(entries);
        }
        return category;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("parentCategoryIds", parentCategoryIds);
        attributes.put("assetVocabularyIds", vocabularyIds);
        attributes.put("title", title);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(title);
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected long[] getCategoryIds(List<AssetCategory> categories) {
        return ListUtil.toLongArray(categories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    protected String[] getCategoryNames(List<AssetCategory> categories) {
        return (String[])ListUtil.toArray(categories, (Accessor)AssetCategory.NAME_ACCESSOR);
    }

    protected BaseModelSearchResult<AssetCategory> searchCategories(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetCategory.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetCategory> categories = this.getCategories(hits);
            if (categories == null) continue;
            return new BaseModelSearchResult(categories, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void updateChildrenVocabularyId(AssetCategory category, long vocabularyId) {
        List childrenCategories = this.assetCategoryPersistence.findByParentCategoryId(category.getCategoryId());
        if (!childrenCategories.isEmpty()) {
            for (AssetCategory childCategory : childrenCategories) {
                childCategory.setVocabularyId(vocabularyId);
                this.assetCategoryPersistence.update((BaseModel)childCategory);
                this.updateChildrenVocabularyId(childCategory, vocabularyId);
            }
        }
    }

    protected void validate(long categoryId, long parentCategoryId, String name, long vocabularyId) throws PortalException {
        if (Validator.isNull((String)name)) {
            StringBundler sb = new StringBundler(5);
            sb.append("Asset category name cannot be null for key {categoryId=");
            sb.append(categoryId);
            sb.append(", vocabularyId=");
            sb.append(vocabularyId);
            sb.append("}");
            throw new AssetCategoryNameException(StringBundler.concat((String[])new String[]{"Category name cannot be null for category ", String.valueOf(categoryId), " and vocabulary ", String.valueOf(vocabularyId)}));
        }
        AssetCategory category = this.assetCategoryPersistence.fetchByP_N_V(parentCategoryId, name, vocabularyId);
        if (category != null && category.getCategoryId() != categoryId) {
            StringBundler sb = new StringBundler(4);
            sb.append("There is another category named ");
            sb.append(name);
            sb.append(" as a child of category ");
            sb.append(parentCategoryId);
            throw new DuplicateCategoryException(sb.toString());
        }
    }
}

