/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.NoSuchLinkException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetLinkConstants;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.asset.model.impl.AssetLinkImpl;
import com.liferay.portlet.asset.service.base.AssetLinkLocalServiceBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssetLinkLocalServiceImpl
extends AssetLinkLocalServiceBaseImpl {
    private static final String _FIND_BY_ASSET_ENTRY_GROUP_ID = AssetLinkLocalServiceImpl.class.getName() + ".findByAssetEntryGroupId";
    private static final Log _log = LogFactoryUtil.getLog(AssetLinkLocalServiceImpl.class);

    public AssetLink addLink(long userId, long entryId1, long entryId2, int type, int weight) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        long linkId = this.counterLocalService.increment();
        AssetLink link = this.assetLinkPersistence.create(linkId);
        link.setCompanyId(user.getCompanyId());
        link.setUserId(user.getUserId());
        link.setUserName(user.getFullName());
        link.setCreateDate(now);
        link.setEntryId1(entryId1);
        link.setEntryId2(entryId2);
        link.setType(type);
        link.setWeight(weight);
        this.assetLinkPersistence.update((BaseModel)link);
        if (AssetLinkConstants.isTypeBi((int)type)) {
            long linkId2 = this.counterLocalService.increment();
            AssetLink link2 = this.assetLinkPersistence.create(linkId2);
            link2.setCompanyId(user.getCompanyId());
            link2.setUserId(user.getUserId());
            link2.setUserName(user.getFullName());
            link2.setCreateDate(now);
            link2.setEntryId1(entryId2);
            link2.setEntryId2(entryId1);
            link2.setType(type);
            link2.setWeight(weight);
            this.assetLinkPersistence.update((BaseModel)link2);
        }
        return link;
    }

    @Override
    public AssetLink deleteAssetLink(AssetLink assetLink) {
        AssetLink deletedAssetLink = super.deleteAssetLink(assetLink);
        this.addDeletionSystemEvent(assetLink);
        return deletedAssetLink;
    }

    @Override
    public AssetLink deleteAssetLink(long linkId) throws PortalException {
        AssetLink assetLink = super.deleteAssetLink(linkId);
        this.addDeletionSystemEvent(assetLink);
        return assetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroupLinks(long groupId) {
        Session session = this.assetLinkPersistence.openSession();
        try {
            String sql = CustomSQLUtil.get((String)_FIND_BY_ASSET_ENTRY_GROUP_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("AssetLink", AssetLinkImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(groupId);
            qPos.add(groupId);
            List assetLinks = sqlQuery.list();
            if (ListUtil.isEmpty((List)assetLinks)) {
                return;
            }
            for (AssetLink assetLink : assetLinks) {
                this.deleteAssetLink(assetLink);
            }
        }
        finally {
            this.assetLinkPersistence.closeSession(session);
            this.assetLinkPersistence.clearCache();
        }
    }

    public void deleteLink(AssetLink link) {
        block3: {
            if (AssetLinkConstants.isTypeBi((int)link.getType())) {
                try {
                    AssetLink assetLink = this.assetLinkPersistence.findByE_E_T(link.getEntryId2(), link.getEntryId1(), link.getType());
                    this.deleteAssetLink(assetLink);
                }
                catch (NoSuchLinkException nsle) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to delete asset link", (Throwable)nsle);
                }
            }
        }
        this.assetLinkPersistence.remove((BaseModel)link);
        this.addDeletionSystemEvent(link);
    }

    public void deleteLink(long linkId) throws PortalException {
        AssetLink link = this.assetLinkPersistence.findByPrimaryKey(linkId);
        this.deleteLink(link);
    }

    public void deleteLinks(long entryId) {
        for (AssetLink link : this.assetLinkPersistence.findByE1(entryId)) {
            this.deleteLink(link);
        }
        for (AssetLink link : this.assetLinkPersistence.findByE2(entryId)) {
            this.deleteLink(link);
        }
    }

    public void deleteLinks(long entryId1, long entryId2) {
        List links = this.assetLinkPersistence.findByE_E(entryId1, entryId2);
        for (AssetLink link : links) {
            this.deleteLink(link);
        }
    }

    public List<AssetLink> getDirectLinks(long entryId) {
        return this.getDirectLinks(entryId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByE1(entryId);
        return this.filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId) {
        return this.getDirectLinks(entryId, typeId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        return this.filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public ExportActionableDynamicQuery getExportActionbleDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Criterion createDateCriterion = portletDataContext.getDateRangeCriteria("createDate");
                if (createDateCriterion != null) {
                    dynamicQuery.add(createDateCriterion);
                }
                DynamicQuery assetEntryDynamicQuery = DynamicQueryFactoryUtil.forClass(AssetEntry.class, (String)"assetEntry", (ClassLoader)AssetLinkLocalServiceImpl.this.getClassLoader());
                assetEntryDynamicQuery.setProjection(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.property((String)"assetEntry.entryId"), (String)"assetEntry.assetEntryId"));
                Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
                Criterion groupIdCriterion = groupIdProperty.eq((Object)portletDataContext.getScopeGroupId());
                assetEntryDynamicQuery.add(groupIdCriterion);
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                Property entryId1Property = PropertyFactoryUtil.forName((String)"entryId1");
                Property entryId2Property = PropertyFactoryUtil.forName((String)"entryId2");
                disjunction.add(entryId1Property.in(assetEntryDynamicQuery));
                disjunction.add(entryId2Property.in(assetEntryDynamicQuery));
                dynamicQuery.add((Criterion)disjunction);
            }
        });
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)this);
        exportActionableDynamicQuery.setClassLoader(this.getClassLoader());
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setModelClass(AssetLink.class);
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<AssetLink>(){

            public void performAction(AssetLink assetLink) throws PortalException {
                StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedAssetLink);
            }
        });
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("linkId");
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(StagedModelType.class));
        return exportActionableDynamicQuery;
    }

    public List<AssetLink> getLinks(long entryId) {
        List e1Links = this.assetLinkPersistence.findByE1(entryId);
        List e2Links = this.assetLinkPersistence.findByE2(entryId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getLinks(long entryId, int typeId) {
        List e1Links = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        List e2Links = this.assetLinkPersistence.findByE2_T(entryId, typeId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getLinks(long classNameId, long classPK) {
        return this.assetLinkFinder.findByC_C(classNameId, classPK);
    }

    public List<AssetLink> getReverseLinks(long entryId, int typeId) {
        return this.assetLinkPersistence.findByE2_T(entryId, typeId);
    }

    public AssetLink updateLink(long userId, long entryId1, long entryId2, int typeId, int weight) throws PortalException {
        AssetLink assetLink = this.assetLinkPersistence.fetchByE_E_T(entryId1, entryId2, typeId);
        if (assetLink == null) {
            return this.addLink(userId, entryId1, entryId2, typeId, weight);
        }
        assetLink.setWeight(weight);
        this.assetLinkPersistence.update((BaseModel)assetLink);
        return assetLink;
    }

    public void updateLinks(long userId, long entryId, long[] linkEntryIds, int typeId) throws PortalException {
        if (linkEntryIds == null) {
            return;
        }
        List<AssetLink> links = this.getLinks(entryId, typeId);
        for (AssetLink link : links) {
            if ((link.getEntryId1() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId2())) && (link.getEntryId2() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId1()))) continue;
            this.deleteLink(link);
        }
        for (Object assetLinkEntryId : (Object)linkEntryIds) {
            AssetLink link;
            if (assetLinkEntryId == entryId || (link = this.assetLinkPersistence.fetchByE_E_T(entryId, (long)assetLinkEntryId, typeId)) != null) continue;
            this.addLink(userId, entryId, (long)assetLinkEntryId, typeId, 0);
        }
    }

    protected void addDeletionSystemEvent(AssetLink assetLink) {
        StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
        StagedModelType stagedModelType = stagedAssetLink.getStagedModelType();
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(assetLink.getEntryId1());
        if (assetEntry == null) {
            return;
        }
        try {
            this.systemEventLocalService.addSystemEvent(0L, assetEntry.getGroupId(), stagedModelType.getClassName(), stagedAssetLink.getPrimaryKey(), stagedAssetLink.getUuid(), null, 1, "");
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected List<AssetLink> filterAssetLinks(List<AssetLink> assetLinks, boolean excludeInvisibleLinks) {
        if (assetLinks.isEmpty() || !excludeInvisibleLinks) {
            return assetLinks;
        }
        ArrayList<AssetLink> filteredAssetLinks = new ArrayList<AssetLink>(assetLinks.size());
        for (AssetLink assetLink : assetLinks) {
            AssetEntry assetEntry = this.assetEntryPersistence.fetchByPrimaryKey(assetLink.getEntryId2());
            if (assetEntry == null || !assetEntry.isVisible()) continue;
            filteredAssetLinks.add(assetLink);
        }
        assetLinks = Collections.unmodifiableList(filteredAssetLinks);
        return assetLinks;
    }
}

