/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBDiscussionLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBThreadLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
@OSGiBeanProperties
public class MBThreadIndexer
extends BaseIndexer<MBThread> {
    public static final String CLASS_NAME = MBThread.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(MBThreadIndexer.class);

    public MBThreadIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"classNameId", "classPK", "companyId", "entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long participantUserId;
        this.addStatus(contextBooleanFilter, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"));
        contextBooleanFilter.addRequiredTerm("discussion", discussion);
        long endDate = GetterUtil.getLong((Object)searchContext.getAttribute("endDate"));
        long startDate = GetterUtil.getLong((Object)searchContext.getAttribute("startDate"));
        if (endDate > 0L && startDate > 0L) {
            contextBooleanFilter.addRangeTerm("lastPostDate", startDate, endDate);
        }
        if ((participantUserId = GetterUtil.getLong((Object)searchContext.getAttribute("participantUserId"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("participantUserIds", participantUserId);
        }
    }

    protected void doDelete(MBThread mbThread) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        this.deleteDocument(mbThread.getCompanyId(), mbThread.getThreadId());
    }

    protected Document doGetDocument(MBThread mbThread) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)mbThread);
        MBDiscussion discussion = MBDiscussionLocalServiceUtil.fetchThreadDiscussion((long)mbThread.getThreadId());
        if (discussion == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        document.addKeyword("lastPostDate", mbThread.getLastPostDate().getTime());
        document.addKeyword("participantUserIds", mbThread.getParticipantUserIds());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(MBThread mbThread) throws Exception {
        Document document = this.getDocument(mbThread);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)mbThread.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        this.doReindex(thread);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected void reindexCategories(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = MBCategoryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBCategory>(){

            public void performAction(MBCategory category) throws PortalException {
                MBThreadIndexer.this.reindexThreads(companyId, category.getGroupId(), category.getCategoryId());
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

            public void performAction(Group group) throws PortalException {
                MBThreadIndexer.this.reindexThreads(companyId, group.getGroupId(), -1L);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

            public void performAction(Group group) throws PortalException {
                MBThreadIndexer.this.reindexThreads(companyId, group.getGroupId(), 0L);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexThreads(long companyId, long groupId, final long categoryId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = MBThreadLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                dynamicQuery.add(statusProperty.eq((Object)0));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBThread>(){

            public void performAction(MBThread thread) {
                block2: {
                    try {
                        Document document = MBThreadIndexer.this.getDocument(thread);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index message boards thread " + thread.getThreadId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

