/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.util.StringPool;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseLayoutTypeControllerImpl
implements LayoutTypeController {
    protected ServletContext servletContext;

    @Override
    public String[] getConfigurationActionDelete() {
        return StringPool.EMPTY_ARRAY;
    }

    @Override
    public String[] getConfigurationActionUpdate() {
        return StringPool.EMPTY_ARRAY;
    }

    @Override
    public String getType() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String includeEditContent(HttpServletRequest request, HttpServletResponse response, Layout layout) throws Exception {
        RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(this.getEditPage());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        ServletResponse servletResponse = this.createServletResponse(response, unsyncStringWriter);
        try {
            this.addAttributes(request);
            requestDispatcher.include((ServletRequest)request, servletResponse);
        }
        finally {
            this.removeAttributes(request);
        }
        return unsyncStringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean includeLayoutContent(HttpServletRequest request, HttpServletResponse response, Layout layout) throws Exception {
        RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(this.getViewPage());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        ServletResponse servletResponse = this.createServletResponse(response, unsyncStringWriter);
        String contentType = servletResponse.getContentType();
        String includeServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        try {
            this.addAttributes(request);
            requestDispatcher.include((ServletRequest)request, servletResponse);
        }
        finally {
            this.removeAttributes(request);
            request.setAttribute("javax.servlet.include.servlet_path", (Object)includeServletPath);
        }
        if (contentType != null) {
            response.setContentType(contentType);
        }
        request.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
        return false;
    }

    @Override
    public boolean isBrowsable() {
        return true;
    }

    @Override
    public boolean isCheckLayoutViewPermission() {
        return true;
    }

    @Override
    public boolean isFullPageDisplayable() {
        return false;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean matches(HttpServletRequest request, String friendlyURL, Layout layout) {
        try {
            Map<Locale, String> friendlyURLMap = layout.getFriendlyURLMap();
            Collection<String> values = friendlyURLMap.values();
            return values.contains(friendlyURL);
        }
        catch (SystemException se) {
            throw new RuntimeException(se);
        }
    }

    protected void addAttributes(HttpServletRequest request) {
    }

    protected abstract ServletResponse createServletResponse(HttpServletResponse var1, UnsyncStringWriter var2);

    protected abstract String getEditPage();

    protected abstract String getViewPage();

    protected void removeAttributes(HttpServletRequest request) {
    }
}

