/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PropertiesSourceProcessor
extends BaseSourceProcessor {
    private String _portalPortalPropertiesContent;

    @Override
    public String[] getIncludes() {
        if (portalSource) {
            return new String[]{"**/portal.properties", "**/portal-ext.properties", "**/portal-legacy-*.properties", "**/portlet.properties", "**/source-formatter.properties"};
        }
        return new String[]{"**/portal.properties", "**/portal-ext.properties", "**/portlet.properties", "**/source-formatter.properties"};
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = content;
        if (fileName.endsWith("portlet.properties")) {
            newContent = this.formatPortletProperties(fileName, content);
        } else if (fileName.endsWith("source-formatter.properties")) {
            this.formatSourceFormatterProperties(fileName, content);
        } else if (portalSource && fileName.endsWith("portal.properties")) {
            newContent = this.formatPortalPortalProperties(fileName, content);
        } else {
            this.formatPortalProperties(fileName, content);
        }
        return newContent;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    protected String formatPortalPortalProperties(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = this.trimLine(line, true)).startsWith("\t")) {
                    line = line.replace("\t", "    ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected void formatPortalProperties(String fileName, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            int previousPos = -1;
            String portalPortalPropertiesContent = this.getPortalPortalProperties();
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                int pos = line.indexOf(61);
                if (pos == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos + 1));
                pos = portalPortalPropertiesContent.indexOf("    " + property);
                if (pos == -1) continue;
                if (pos < previousPos) {
                    this.processErrorMessage(fileName, "sort " + fileName + " " + lineCount);
                }
                previousPos = pos;
            }
        }
    }

    protected String formatPortletProperties(String fileName, String content) throws Exception {
        if (!content.contains("include-and-override=portlet-ext.properties")) {
            content = "include-and-override=portlet-ext.properties\n\n" + content;
        }
        if (!portalSource) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            String previousProperty = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos;
                if (++lineCount == 1 || line.startsWith("#") || line.startsWith(" ") || line.startsWith("\t") || (pos = line.indexOf(61)) == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos));
                if ((pos = property.indexOf(91)) != -1) {
                    property = property.substring(0, pos);
                }
                if (Validator.isNotNull(previousProperty) && previousProperty.compareToIgnoreCase(property) > 0) {
                    this.processErrorMessage(fileName, "sort: " + fileName + " " + lineCount);
                }
                previousProperty = property;
            }
        }
        return content;
    }

    protected void formatSourceFormatterProperties(String fileName, String content) throws Exception {
        String path = "";
        int pos = fileName.lastIndexOf(47);
        if (pos != -1) {
            path = fileName.substring(0, pos + 1);
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(fileName);
        properties.load(inputStream);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String value;
            String key = (String)enu.nextElement();
            if (!key.endsWith("excludes.files") || Validator.isNull(value = properties.getProperty(key))) continue;
            List<String> propertyFileNames = ListUtil.fromString(value, ",");
            for (String propertyFileName : propertyFileNames) {
                File file;
                pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((file = new File(path + propertyFileName)).exists()) continue;
                this.processErrorMessage(fileName, "Incorrect property value: " + propertyFileName + " " + fileName);
            }
        }
    }

    protected String getPortalPortalProperties() throws Exception {
        if (this._portalPortalPropertiesContent != null) {
            return this._portalPortalPropertiesContent;
        }
        if (portalSource) {
            File file = this.getFile("portal-impl/src/portal.properties", 5);
            this._portalPortalPropertiesContent = FileUtil.read(file);
            return this._portalPortalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        this._portalPortalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        return this._portalPortalPropertiesContent;
    }
}

