/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.ant;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatter;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SourceFormatterTask
extends Task {
    private final Set<FileSet> _fileSets = new HashSet<FileSet>();
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public void addFileset(FileSet fileSet) {
        this._fileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        if (!this._fileSets.isEmpty()) {
            this._collectFromFileSets();
        }
        try {
            SourceFormatter sourceFormatter = new SourceFormatter(this._sourceFormatterArgs);
            sourceFormatter.format();
            List<String> modifiedFileNames = sourceFormatter.getModifiedFileNames();
            Project project = this.getProject();
            project.addIdReference("source.formatter.modified.files", modifiedFileNames);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDir(String baseDir) {
        this._sourceFormatterArgs.setBaseDirName(baseDir);
    }

    public void setCopyright(String copyright) {
        this._sourceFormatterArgs.setCopyrightFileName(copyright);
    }

    public void setFileNames(String fileNames) {
        this._sourceFormatterArgs.setFileNames(Arrays.asList(StringUtil.split(fileNames)));
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }

    public void setUseProperties(boolean useProperties) {
        this._sourceFormatterArgs.setUseProperties(useProperties);
    }

    private void _collectFromFileSets() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileSet fileSet : this._fileSets) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            File baseDir = directoryScanner.getBasedir();
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                File file = new File(baseDir, includedFiles[i]);
                includedFiles[i] = file.getAbsolutePath();
            }
            fileNames.addAll(Arrays.asList(includedFiles));
        }
        this._sourceFormatterArgs.setFileNames(fileNames);
    }
}

