/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class GitUtil {
    public static List<String> getLatestAuthorFileNames(String baseDirName) throws Exception {
        ArrayList<String> latestAuthorFileNames = new ArrayList<String>();
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        if (gitLevel == -1) {
            return latestAuthorFileNames;
        }
        InputStream gitCommandInputStream = GitUtil.getGitCommandInputStream("git log");
        if (gitCommandInputStream == null) {
            return latestAuthorFileNames;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(gitCommandInputStream));
        String line = null;
        String commitId = null;
        String latestAuthor = null;
        ArrayList<String> latestAuthorCommitIds = new ArrayList<String>();
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("commit ")) {
                commitId = line.substring(7);
                continue;
            }
            if (!line.startsWith("Author: ")) continue;
            if (latestAuthor == null) {
                int x = line.lastIndexOf(60);
                int y = line.lastIndexOf(62);
                latestAuthor = line.substring(x + 1, y);
                latestAuthorCommitIds.add(commitId);
                continue;
            }
            if (!line.endsWith("<" + latestAuthor + ">")) break;
            latestAuthorCommitIds.add(commitId);
        }
        for (String latestAuthorCommitId : latestAuthorCommitIds) {
            gitCommandInputStream = GitUtil.getGitCommandInputStream("git diff-tree --no-commit-id --name-only -r " + latestAuthorCommitId);
            String output = StringUtil.read(gitCommandInputStream);
            for (String outputLine : StringUtil.splitLines(output)) {
                String fileName;
                if (StringUtil.count(outputLine, "/") < gitLevel || latestAuthorFileNames.contains(fileName = GitUtil.getFileName(outputLine, gitLevel))) continue;
                latestAuthorFileNames.add(fileName);
            }
        }
        return latestAuthorFileNames;
    }

    public static List<String> getLocalChangesFileNames(String baseDirName) throws Exception {
        ArrayList<String> localChangesFileNames = new ArrayList<String>();
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        if (gitLevel == -1) {
            return localChangesFileNames;
        }
        InputStream gitCommandInputStream = GitUtil.getGitCommandInputStream("git add . --dry-run");
        if (gitCommandInputStream == null) {
            return localChangesFileNames;
        }
        String output = StringUtil.read(gitCommandInputStream);
        for (String line : StringUtil.splitLines(output)) {
            if (!line.startsWith("add '") || StringUtil.count(line, "/") < gitLevel) continue;
            String fileName = GitUtil.getFileName(line.substring(5, line.length() - 1), gitLevel);
            localChangesFileNames.add(fileName);
        }
        return localChangesFileNames;
    }

    protected static String getFileName(String fileName, int gitLevel) {
        for (int i = 0; i < gitLevel; ++i) {
            int x = fileName.indexOf("/");
            fileName = fileName.substring(x + 1);
        }
        return fileName;
    }

    protected static InputStream getGitCommandInputStream(String gitCommand) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(gitCommand);
        }
        catch (IOException ioe) {
            String errorMessage = ioe.getMessage();
            if (errorMessage.contains("Cannot run program")) {
                System.out.println("Add Git to your PATH system variable first.");
                return null;
            }
            throw ioe;
        }
        return process.getInputStream();
    }

    protected static int getGitLevel(String baseDirName) {
        for (int i = 0; i < 5; ++i) {
            File file = new File(baseDirName + ".git");
            if (file.exists()) {
                return i;
            }
            baseDirName = "../" + baseDirName;
        }
        System.out.println("Unable to retrieve files because .git directory is missing.");
        return -1;
    }
}

