/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.Reader;
import java.io.Writer;

public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static final MinifierUtil _instance = new MinifierUtil();
    private final ServiceTracker<JavaScriptMinifier, JavaScriptMinifier> _javaScriptMinifierServiceTracker;

    public static String minifyCss(String content) {
        if (!PropsValues.MINIFIER_ENABLED) {
            return content;
        }
        return _instance._minifyCss(content);
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (!PropsValues.MINIFIER_ENABLED) {
            return content;
        }
        return _instance._minifyJavaScript(resourceName, content);
    }

    private MinifierUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._javaScriptMinifierServiceTracker = registry.trackServices(JavaScriptMinifier.class);
        this._javaScriptMinifierServiceTracker.open();
    }

    private String _minifyCss(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CssCompressor cssCompressor = new CssCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
            return this._processMinifiedCss(unsyncStringWriter.toString());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to minify CSS:\n" + content), (Throwable)e);
            unsyncStringWriter.append((CharSequence)content);
            return unsyncStringWriter.toString();
        }
    }

    private String _minifyJavaScript(String resourceName, String content) {
        JavaScriptMinifier javaScriptMinifier = (JavaScriptMinifier)this._javaScriptMinifierServiceTracker.getService();
        if (javaScriptMinifier == null) {
            return content;
        }
        return javaScriptMinifier.compress(resourceName, content);
    }

    private String _processMinifiedCss(String minifiedCss) {
        int index = 0;
        while ((index = minifiedCss.indexOf("calc(", index)) != -1) {
            int parenthesesCount = 0;
            int startIndex = index += 5;
            parenthesesCount = 1;
            while (parenthesesCount != 0 && index < minifiedCss.length()) {
                char c = minifiedCss.charAt(index);
                if (c == '(') {
                    ++parenthesesCount;
                } else if (c == ')') {
                    --parenthesesCount;
                }
                ++index;
            }
            if (parenthesesCount != 0) continue;
            StringBundler sb = new StringBundler(3);
            sb.append(minifiedCss.substring(0, startIndex));
            String replacement = minifiedCss.substring(startIndex, index - 1);
            replacement = this._separateOperatorsFromNegativeNumbers(replacement);
            replacement = this._surroundDivisionOperatorsWithSpaces(replacement);
            replacement = this._surroundMultiplicationOperatorsWithSpaces(replacement);
            replacement = this._surroundSubstractionOperatorsWithSpaces(replacement);
            replacement = this._surroundSumOperatorsWithSpaces(replacement);
            replacement = this._removeSpacesInsideNegativeNumbers(replacement);
            sb.append(replacement);
            sb.append(minifiedCss.substring(index - 1));
            index += replacement.length() - (index - startIndex);
            minifiedCss = sb.toString();
        }
        return minifiedCss;
    }

    private String _removeSpacesInsideNegativeNumbers(String replacement) {
        String anyMinusPrecededByAnOperator = "([+\\-*/])[ ]+-[ ]+(\\d)";
        String leftmostMinus = "^- ";
        replacement = replacement.replaceAll(anyMinusPrecededByAnOperator, "$1 -$2");
        replacement = replacement.replaceAll(leftmostMinus, "-");
        return replacement;
    }

    private String _separateOperatorsFromNegativeNumbers(String replacement) {
        replacement = replacement.replaceAll("\\+-", "+ -");
        replacement = replacement.replaceAll("--", "- -");
        replacement = replacement.replaceAll("\\*-", "* -");
        replacement = replacement.replaceAll("/-", "/ -");
        return replacement;
    }

    private String _surroundDivisionOperatorsWithSpaces(String replacement) {
        replacement = replacement.replaceAll("([^ ])/", "$1 /");
        replacement = replacement.replaceAll("/([^ ])", "/ $1");
        return replacement;
    }

    private String _surroundMultiplicationOperatorsWithSpaces(String replacement) {
        replacement = replacement.replaceAll("([^ ])\\*", "$1 *");
        replacement = replacement.replaceAll("\\*([^ ])", "* $1");
        return replacement;
    }

    private String _surroundSubstractionOperatorsWithSpaces(String replacement) {
        replacement = replacement.replaceAll("([^ ])-", "$1 -");
        replacement = replacement.replaceAll("-([^ ])", "- $1");
        return replacement;
    }

    private String _surroundSumOperatorsWithSpaces(String replacement) {
        replacement = replacement.replaceAll("([^ ])\\+", "$1 +");
        replacement = replacement.replaceAll("\\+([^ ])", "+ $1");
        return replacement;
    }
}

