/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.adapter.builder;

import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilder;
import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilderLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ServiceTrackerMapModelAdapterBuilderLocator
implements ModelAdapterBuilderLocator,
Closeable {
    private final ServiceTrackerMap<String, ModelAdapterBuilder> _modelAdapterBuilders = ServiceTrackerCollections.openSingleValueMap(ModelAdapterBuilder.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, ModelAdapterBuilder>(){

        public void map(ServiceReference<ModelAdapterBuilder> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            ModelAdapterBuilder modelAdapterBuilder = (ModelAdapterBuilder)registry.getService(serviceReference);
            Type genericInterface = ServiceTrackerMapModelAdapterBuilderLocator.this._getGenericInterface(modelAdapterBuilder, ModelAdapterBuilder.class);
            if (genericInterface == null || !(genericInterface instanceof ParameterizedType)) {
                return;
            }
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            Object[] typeArguments = parameterizedType.getActualTypeArguments();
            if (ArrayUtil.isEmpty((Object[])typeArguments) || typeArguments.length != 2) {
                return;
            }
            try {
                Class adapteeModelClass = (Class)typeArguments[0];
                Class adaptedModelClass = (Class)typeArguments[1];
                emitter.emit((Object)ServiceTrackerMapModelAdapterBuilderLocator.this._getKey(adapteeModelClass, adaptedModelClass));
            }
            catch (ClassCastException cce) {
                return;
            }
        }
    });

    @Override
    public void close() {
        this._modelAdapterBuilders.close();
    }

    public <T, V> ModelAdapterBuilder<T, V> locate(Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return (ModelAdapterBuilder)this._modelAdapterBuilders.getService((Object)this._getKey(adapteeModelClass, adaptedModelClass));
    }

    private Type _getGenericInterface(Class<?> clazz, Class<?> interfaceClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !(rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()).equals(interfaceClass)) continue;
            return parameterizedType;
        }
        return null;
    }

    private Type _getGenericInterface(Object object, Class<?> interfaceClass) {
        Class<?> clazz = object.getClass();
        Type genericInterface = this._getGenericInterface(clazz, interfaceClass);
        if (genericInterface != null) {
            return genericInterface;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            genericInterface = this._getGenericInterface(superClass, interfaceClass);
            if (genericInterface == null) continue;
            return genericInterface;
        }
        return null;
    }

    private <T, V> String _getKey(Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return adapteeModelClass.getName() + "->" + adaptedModelClass.getName();
    }
}

