/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.v6_2_0.util.DDMTemplateTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class UpgradeDynamicDataMapping
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDynamicDataMapping.class);

    protected void doUpgrade() throws Exception {
        this.updateSchema();
        this.updateStructures();
        this.updateStructuresClassNameId();
        this.updateTemplates();
    }

    protected void updateMetadataElement(Element metadataElement, String[] relocatedMetadadaEntryNames, String[] removedMetadataEntryNames) {
        Element parentElement = metadataElement.getParent();
        List entryElements = metadataElement.elements("entry");
        for (Element entryElement : entryElements) {
            String name = entryElement.attributeValue("name");
            if (ArrayUtil.contains((Object[])removedMetadataEntryNames, (Object)name)) {
                metadataElement.remove(entryElement);
                continue;
            }
            if (!ArrayUtil.contains((Object[])relocatedMetadadaEntryNames, (Object)name)) continue;
            parentElement.addAttribute(name, entryElement.getText());
            metadataElement.remove(entryElement);
        }
    }

    protected void updateSchema() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.alter(DDMTemplateTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "classNameId LONG"), new UpgradeProcess.AlterColumnName((UpgradeProcess)this, "structureId", "classPK LONG")});
            long classNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.dynamicdatamapping.model.DDMStructure");
            try {
                this.runSQL("update DDMTemplate set classNameId = " + classNameId);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void updateStructure(long structureId, String structureKey, String xsd) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update DDMStructure set structureKey = ?, xsd = ? where structureId = ?");){
                ps.setString(1, structureKey);
                ps.setString(2, xsd);
                ps.setLong(3, structureId);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select structureId, structureKey, xsd from DDMStructure");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long structureId = rs.getLong("structureId");
                String structureKey = rs.getString("structureKey");
                String xsd = rs.getString("xsd");
                structureKey = Validator.isNull((String)structureKey) ? String.valueOf(System.currentTimeMillis()) : StringUtil.toUpperCase((String)structureKey.trim());
                this.updateStructure(structureId, structureKey, this.updateXSD(xsd, structureKey));
            }
        }
    }

    protected void updateStructuresClassNameId() throws Exception {
        block26: {
            try (LoggingTimer loggingTimer = new LoggingTimer();
                 PreparedStatement ps = this.connection.prepareStatement("update DDMStructure set classNameId = ? where classNameId = ?");){
                ps.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata"));
                ps.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.portlet.documentlibrary.model.DLFileEntry"));
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block26;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateTemplate(long templateId, String templateKey, String script) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update DDMTemplate set templateKey = ?, script = ? where templateId = ?");){
            ps.setString(1, templateKey);
            ps.setString(2, script);
            ps.setLong(3, templateId);
            ps.executeUpdate();
        }
    }

    protected void updateTemplates() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select templateId, templateKey, script from DDMTemplate where language = 'xsd'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long templateId = rs.getLong("templateId");
                String templateKey = rs.getString("templateKey");
                String script = rs.getString("script");
                templateKey = Validator.isNull((String)templateKey) ? String.valueOf(System.currentTimeMillis()) : StringUtil.toUpperCase((String)templateKey.trim());
                this.updateTemplate(templateId, templateKey, this.updateXSD(script, ""));
            }
        }
    }

    protected String updateXSD(String xsd, String structureKey) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement, structureKey);
        }
        return XMLUtil.formatXML((Document)document);
    }

    protected void updateXSDDynamicElement(Element element, String structureKey) {
        Element metadataElement = element.element("meta-data");
        this.updateMetadataElement(metadataElement, new String[]{"multiple", "name", "readOnly", "repeatable", "required", "showLabel", "type", "width"}, new String[]{"acceptFiles", "displayChildLabelAsValue", "fieldCssClass", "folder"});
        if (StringUtil.equalsIgnoreCase((String)structureKey, (String)"TIKARAWMETADATA")) {
            element.addAttribute("indexType", "text");
        }
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement, structureKey);
        }
    }
}

