/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+[^$].*;\n+)+", 8);

    protected static List<String> getImportsList(String content) {
        ArrayList<String> importsList = new ArrayList<String>();
        Matcher matcher = _importsPattern.matcher(content);
        while (matcher.find()) {
            importsList.add(matcher.group());
        }
        return importsList;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        return this.createJavaImportPackage(line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        List<String> importsList = FTLImportsFormatter.getImportsList(content);
        for (String imports : importsList) {
            content = this.doFormat(content, packageDir, className, imports);
        }
        return content;
    }

    protected String doFormat(String content, String packageDir, String className, String imports) throws IOException {
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this.sortAndGroupImports(imports);
        if (!imports.equals(newImports)) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        content = content.replaceAll("(?m)^([ \t]*package .*;|</#.*>)\\s*^([ \t]*import)", "$1\n\n$2");
        content = content.replaceAll("(?m)^([ \t]*(?:package|import) .*;)\\s*^([ \t]*/\\*\\*|@|<#)", "$1\n\n$2");
        return content;
    }
}

