/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDStylingCheck
extends BaseFileCheck {
    private final Pattern _incorrectIndentPattern = Pattern.compile("\n[^\t].*:\\\\\n(\t{2,})[^\t]");
    private final Pattern _incorrectLineBreakPattern = Pattern.compile("(\\A|[^\\\\]\n)(\t*)([-\\w]+:)\\s*(.*,\\\\(\n|\\Z))");
    private final Pattern _multipleValuesOnSingleLinePattern = Pattern.compile(",(?!\\\\(\n|\\Z)).");
    private final Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*:(\\\\\n\t).*(\n[^\t]|\\Z)");
    private final Pattern _trailingSemiColonPattern = Pattern.compile(";(\n|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = StringUtil.replace(content, new String[]{"/\n", "/,\\\n", " \\\n"}, new String[]{"\n", ",\\\n", "\\\n"});
        content = this._fixIncorrectIndent(content);
        content = this._fixIncorrectLineBreak(content);
        content = this._fixTrailingSemiColon(content);
        content = this._formatMultipleValuesOnSingleLine(content);
        content = this._formatSingleValueOnMultipleLines(content);
        return content;
    }

    private String _fixIncorrectIndent(String content) {
        Matcher matcher = this._incorrectIndentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, matcher.group(1), "\t", matcher.start());
        }
        return content;
    }

    private String _fixIncorrectLineBreak(String content) {
        Matcher matcher = this._incorrectLineBreakPattern.matcher(content);
        if (matcher.find()) {
            return matcher.replaceAll("$1$2$3\\\\\n$2\t$4");
        }
        return content;
    }

    private String _fixTrailingSemiColon(String content) {
        Matcher matcher = this._trailingSemiColonPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, ";", "", matcher.start());
        }
        return content;
    }

    private String _formatMultipleValuesOnSingleLine(String content) {
        Matcher matcher = this._multipleValuesOnSingleLinePattern.matcher(content);
        while (matcher.find()) {
            int x;
            String s;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (s = content.substring((x = content.lastIndexOf(10, matcher.start())) + 1, matcher.start())).contains("-Description: ")) continue;
            content = StringUtil.insert(content, "\\\n\t", matcher.start() + 1);
            if (s.startsWith("\t")) {
                return content;
            }
            if ((x = content.indexOf(": ", x + 1)) == -1 || x > matcher.start()) continue;
            return StringUtil.replaceFirst(content, " ", "\\\n\t", x);
        }
        return content;
    }

    private String _formatSingleValueOnMultipleLines(String content) {
        Matcher matcher = this._singleValueOnMultipleLinesPattern.matcher(content);
        if (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        return content;
    }
}

