/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConstructorParameterOrderCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaSignature signature = javaTerm.getSignature();
        List<JavaParameter> parameters = signature.getParameters();
        if (!parameters.isEmpty()) {
            this._checkConstructorParameterOrder(fileName, javaTerm, parameters);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR};
    }

    private void _checkConstructorParameterOrder(String fileName, JavaTerm javaTerm, List<JavaParameter> parameters) {
        String previousParameterName = null;
        int previousPos = -1;
        for (JavaParameter parameter : parameters) {
            String beforeParameter;
            String parameterName = parameter.getParameterName();
            Pattern pattern = Pattern.compile(StringBundler.concat("\\{\n([\\s\\S]*?)(_", parameterName, " =[ \t\n]+", parameterName, ";)"));
            Matcher matcher = pattern.matcher(javaTerm.getContent());
            if (!matcher.find() || (beforeParameter = matcher.group(1)).contains(parameterName + " =")) continue;
            int pos = matcher.start(2);
            if (previousPos < pos) {
                previousParameterName = parameterName;
                previousPos = pos;
                continue;
            }
            StringBundler sb = new StringBundler(9);
            sb.append("'_");
            sb.append(previousParameterName);
            sb.append(" = ");
            sb.append(previousParameterName);
            sb.append(";' should come before '_");
            sb.append(parameterName);
            sb.append(" = ");
            sb.append(parameterName);
            sb.append(";' to match order of constructor parameters");
            this.addMessage(fileName, sb.toString(), "constructor_parameters.markdown");
            return;
        }
    }
}

