/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";

    public int[] getDefaultTokens() {
        return new int[]{80};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() == 59) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        DetailAST nameAST = null;
        if (parentAST.getType() == 28) {
            nameAST = detailAST.findFirstToken(58);
        } else if (parentAST.getType() == 10) {
            nameAST = parentAST.findFirstToken(58);
        }
        if (nameAST == null) {
            return;
        }
        this._checkMissingEmptyLineAfterReferencingVariable(parentAST, nameAST.getText(), DetailASTUtil.getEndLine(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentAST, nameAST.getText(), DetailASTUtil.getEndLine(detailAST));
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String name, int endLine) {
        DetailAST previousIdentAST = null;
        boolean referenced = false;
        DetailAST nextSibling = detailAST.getNextSibling();
        while (nextSibling != null && nextSibling.getType() == 45) {
            if ((nextSibling = nextSibling.getNextSibling()) == null || nextSibling.getType() != 28 && nextSibling.getType() != 10) {
                return;
            }
            boolean expressionReferencesVariable = false;
            List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSibling, true, 58);
            for (DetailAST identAST : identASTList) {
                String identName = identAST.getText();
                if (!identName.equals(name)) continue;
                expressionReferencesVariable = true;
                previousIdentAST = identAST;
            }
            if (!expressionReferencesVariable) {
                if (!referenced) {
                    return;
                }
                int startLineNextExpression = DetailASTUtil.getStartLine(nextSibling);
                if (endLine + 1 != startLineNextExpression) {
                    return;
                }
                if (this._isReferencesNewVariable(previousIdentAST) && (this._hasAssignTokenType(previousIdentAST) || this._isNestedMethodCall(previousIdentAST) || this._isReferencesNewVariableSetter(previousIdentAST))) {
                    return;
                }
                this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{startLineNextExpression, name});
                return;
            }
            referenced = true;
            endLine = DetailASTUtil.getEndLine(nextSibling);
            nextSibling = nextSibling.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLine) {
        DetailAST nextSibling = detailAST.getNextSibling();
        if (nextSibling == null || nextSibling.getType() != 45) {
            return;
        }
        if ((nextSibling = nextSibling.getNextSibling()) == null) {
            return;
        }
        int startLineNextExpression = DetailASTUtil.getStartLine(nextSibling);
        if (endLine + 1 != startLineNextExpression) {
            return;
        }
        if (this._isExpressionAssignsVariable(nextSibling, name)) {
            return;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSibling, true, 58);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(name)) continue;
            this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private boolean _hasAssignTokenType(DetailAST identAST) {
        if (identAST == null) {
            return false;
        }
        for (DetailAST parentAST = identAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() == 80) {
                return true;
            }
            if (parentAST.getType() != 45) continue;
            return false;
        }
        return false;
    }

    private boolean _isExpressionAssignsVariable(DetailAST detailAST, String name) {
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = detailAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        DetailAST expressionNameAST = childAST.findFirstToken(58);
        if (expressionNameAST == null) {
            return false;
        }
        String expressionName = expressionNameAST.getText();
        return expressionName.equals(name);
    }

    private boolean _isNestedMethodCall(DetailAST identAST) {
        if (identAST == null) {
            return false;
        }
        DetailAST parentAST = identAST.getParent();
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST == null || parentAST.getType() != 27) {
            return false;
        }
        if ((parentAST = parentAST.getParent()) != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        return parentAST != null && parentAST.getType() == 27;
    }

    private boolean _isReferencesNewVariable(DetailAST identAST) {
        if (identAST == null) {
            return false;
        }
        DetailAST parentAST = identAST.getParent();
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST == null || parentAST.getType() != 27) {
            return false;
        }
        DetailAST firstChild = parentAST.getFirstChild();
        if (firstChild == null || firstChild.getType() != 59) {
            return false;
        }
        if ((firstChild = firstChild.getFirstChild()) == null || firstChild.getType() != 58) {
            return false;
        }
        return !Objects.equals(firstChild.getText(), identAST.getText());
    }

    private boolean _isReferencesNewVariableSetter(DetailAST identAST) {
        if (identAST == null) {
            return false;
        }
        DetailAST parentAST = identAST.getParent();
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST != null) {
            parentAST = parentAST.getParent();
        }
        if (parentAST == null || parentAST.getType() != 27) {
            return false;
        }
        DetailAST firstChild = parentAST.getFirstChild();
        if (firstChild == null || firstChild.getType() != 59) {
            return false;
        }
        if ((firstChild = firstChild.getFirstChild()) == null || firstChild.getType() != 58) {
            return false;
        }
        DetailAST detailAST = firstChild.getNextSibling();
        if (detailAST == null || detailAST.getType() != 58) {
            return false;
        }
        return StringUtil.startsWith(detailAST.getText(), "set");
    }
}

