/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.InputSource;

public class CheckstyleUtil {
    public static final int BATCH_SIZE = 1000;

    public static Configuration addAttribute(Configuration configuration, String key, String value, String ... regexChecks) {
        String name;
        if (!(configuration instanceof DefaultConfiguration)) {
            return configuration;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        DefaultConfiguration treeWalkerModule = null;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            name = childConfiguration.getName();
            if (!name.equals("TreeWalker") || !(childConfiguration instanceof DefaultConfiguration)) continue;
            treeWalkerModule = (DefaultConfiguration)childConfiguration;
            break;
        }
        if (treeWalkerModule == null) {
            return configuration;
        }
        for (Configuration childConfiguration : treeWalkerModule.getChildren()) {
            if (!(childConfiguration instanceof DefaultConfiguration)) continue;
            name = childConfiguration.getName();
            for (String regexCheck : regexChecks) {
                if (!name.matches(regexCheck)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)childConfiguration;
                defaultChildConfiguration.addAttribute(key, value);
            }
        }
        return defaultConfiguration;
    }

    public static List<String> getCheckNames(Configuration configuration) {
        ArrayList<String> checkNames = new ArrayList<String>();
        String name = configuration.getName();
        if (name.startsWith("com.liferay.")) {
            int pos = name.lastIndexOf(46);
            checkNames.add(name.substring(pos + 1));
        }
        for (Configuration childConfiguration : configuration.getChildren()) {
            checkNames.addAll(CheckstyleUtil.getCheckNames(childConfiguration));
        }
        return checkNames;
    }

    public static Configuration getConfiguration(String configurationFileName, Map<String, Properties> propertiesMap, int maxLineLength, boolean showDebugInformation) throws Exception {
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream(configurationFileName)), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
        configuration = CheckstyleUtil.addAttribute(configuration, "allowedClassNames", CheckstyleUtil._getPropertyValue(propertiesMap, "chaining.allowed.class.names"), "com.liferay.source.formatter.checkstyle.checks.ChainingCheck");
        configuration = CheckstyleUtil.addAttribute(configuration, "allowedVariableTypeNames", CheckstyleUtil._getPropertyValue(propertiesMap, "chaining.allowed.variable.types"), "com.liferay.source.formatter.checkstyle.checks.ChainingCheck");
        configuration = CheckstyleUtil.addAttribute(configuration, "maxLineLength", String.valueOf(maxLineLength), "com.liferay.source.formatter.checkstyle.checks.AppendCheck");
        configuration = CheckstyleUtil.addAttribute(configuration, "maxLineLength", String.valueOf(maxLineLength), "com.liferay.source.formatter.checkstyle.checks.ConcatCheck");
        configuration = CheckstyleUtil.addAttribute(configuration, "maxLineLength", String.valueOf(maxLineLength), "com.liferay.source.formatter.checkstyle.checks.PlusStatementCheck");
        configuration = CheckstyleUtil.addAttribute(configuration, "showDebugInformation", String.valueOf(showDebugInformation), "com.liferay.*");
        if (showDebugInformation) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, CheckstyleUtil.getCheckNames(configuration));
        }
        return configuration;
    }

    private static String _getPropertyValue(Map<String, Properties> propertiesMap, String key) {
        StringBundler sb = new StringBundler(propertiesMap.size() * 2);
        for (Map.Entry<String, Properties> entry : propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            String value = properties.getProperty(key);
            if (value == null) continue;
            sb.append(value);
            sb.append(',');
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

