/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.content;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ContentUtil {
    private static final Log _log = LogFactoryUtil.getLog(ContentUtil.class);
    private static final ContentUtil _instance = new ContentUtil();
    private final Map<String, String> _contentPool = new HashMap<String, String>();

    public static String get(ClassLoader classLoader, String location) {
        return _instance._get(classLoader, location, false);
    }

    public static String get(ClassLoader classLoader, String location, boolean all) {
        return _instance._get(classLoader, location, all);
    }

    private ContentUtil() {
    }

    private String _get(ClassLoader classLoader, String location, boolean all) {
        String content = this._contentPool.get(location);
        if (content == null) {
            try {
                content = StringUtil.read((ClassLoader)classLoader, (String)location, (boolean)all);
                this._put(location, content);
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return content;
    }

    private void _put(String location, String content) {
        this._contentPool.put(location, content);
    }
}

