/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;

public abstract class BaseSettings
implements Settings {
    protected Settings parentSettings;

    public BaseSettings() {
    }

    public BaseSettings(Settings parentSettings) {
        this.parentSettings = parentSettings;
    }

    @Override
    public ModifiableSettings getModifiableSettings() {
        if (this instanceof ModifiableSettings) {
            return (ModifiableSettings)((Object)this);
        }
        if (this.parentSettings == null) {
            return null;
        }
        return this.parentSettings.getModifiableSettings();
    }

    @Override
    public Settings getParentSettings() {
        return this.parentSettings;
    }

    @Override
    public String getValue(String key, String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        String value = this.doGetValue(key);
        if (value == null && this.parentSettings != null) {
            value = this.parentSettings.getValue(key, defaultValue);
        }
        if (Validator.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String[] getValues(String key, String[] defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        Object[] values = this.doGetValues(key);
        if (ArrayUtil.isEmpty(values) && this.parentSettings != null) {
            values = this.parentSettings.getValues(key, defaultValue);
        }
        if (ArrayUtil.isEmpty(values)) {
            values = defaultValue;
        }
        return values;
    }

    protected abstract String doGetValue(String var1);

    protected abstract String[] doGetValues(String var1);
}

