/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.dao.sql.transformer.HQLToJPQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.JPQLToHQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.SQLTransformerFactory;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SQLTransformer {
    private static final SQLTransformer _instance = new SQLTransformer();
    private com.liferay.portal.dao.sql.transformer.SQLTransformer _sqlTransformer;
    private Map<String, String> _transformedSqls;

    public static void reloadSQLTransformer() {
        _instance._reloadSQLTransformer();
    }

    public static String transform(String sql) {
        com.liferay.portal.dao.sql.transformer.SQLTransformer sqlTransformer = _instance._getSQLTransformer();
        return sqlTransformer.transform(sql);
    }

    @Deprecated
    public static String transformFromHqlToJpql(String sql) {
        return SQLTransformer.transformFromHQLToJQPL(sql);
    }

    public static String transformFromHQLToJQPL(String sql) {
        return _instance._transformFromHQLToJPQL(sql);
    }

    @Deprecated
    public static String transformFromJpqlToHql(String sql) {
        return SQLTransformer.transformFromJPQLToHQL(sql);
    }

    public static String transformFromJPQLToHQL(String sql) {
        return _instance._transformFromJPQLToHQL(sql);
    }

    private SQLTransformer() {
        this._reloadSQLTransformer();
    }

    private com.liferay.portal.dao.sql.transformer.SQLTransformer _getSQLTransformer() {
        return this._sqlTransformer;
    }

    private void _reloadSQLTransformer() {
        if (this._transformedSqls == null) {
            this._transformedSqls = new ConcurrentHashMap<String, String>();
        } else {
            this._transformedSqls.clear();
        }
        DB db = DBManagerUtil.getDB();
        this._sqlTransformer = SQLTransformerFactory.getSQLTransformer(db);
    }

    private String _transformFromHQLToJPQL(String sql) {
        Function[] functions;
        String newSQL = this._transformedSqls.get(sql);
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._sqlTransformer.transform(sql);
        for (Function function : functions = new Function[]{HQLToJPQLTransformerLogic.getPositionalParameterFunction(), HQLToJPQLTransformerLogic.getNotEqualsFunction(), HQLToJPQLTransformerLogic.getCompositeIdMarkerFunction()}) {
            newSQL = (String)function.apply(newSQL);
        }
        this._transformedSqls.put(sql, newSQL);
        return newSQL;
    }

    private String _transformFromJPQLToHQL(String sql) {
        String newSQL = this._transformedSqls.get(sql);
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._sqlTransformer.transform(sql);
        Function<String, String> countFunction = JPQLToHQLTransformerLogic.getCountFunction();
        newSQL = countFunction.apply(newSQL);
        this._transformedSqls.put(sql, newSQL);
        return newSQL;
    }
}

