/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.layoutconfiguration.util.velocity.ColumnProcessor;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.taglib.aui.InputTag;
import java.io.Writer;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;

public class CustomizationSettingsProcessor
implements ColumnProcessor {
    private final boolean _customizationEnabled;
    private final UnicodeProperties _layoutTypeSettings;
    private final PageContext _pageContext;
    private final Writer _writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomizationSettingsProcessor(HttpServletRequest request, HttpServletResponse response) {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader());
            this._pageContext = jspFactory.getPageContext((Servlet)new JSPSupportServlet(request.getServletContext()), (ServletRequest)request, (ServletResponse)response, null, false, 0, false);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
        }
        this._writer = this._pageContext.getOut();
        Layout selLayout = null;
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid", (long)0L);
        if (selPlid != 0L) {
            selLayout = LayoutLocalServiceUtil.fetchLayout((long)selPlid);
        }
        this._layoutTypeSettings = selLayout.getTypeSettingsProperties();
        this._customizationEnabled = SitesUtil.isLayoutUpdateable((Layout)selLayout) && !selLayout.isLayoutPrototypeLinkActive();
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        String customizableKey = CustomizedPages.namespaceColumnId((String)columnId);
        boolean customizable = false;
        if (this._customizationEnabled) {
            customizable = GetterUtil.getBoolean((String)this._layoutTypeSettings.getProperty(customizableKey, String.valueOf(false)));
        }
        this._writer.append("<div class=\"");
        this._writer.append(classNames);
        this._writer.append("\">");
        this._writer.append("<h1>");
        this._writer.append(columnId);
        this._writer.append("</h1>");
        InputTag inputTag = new InputTag();
        inputTag.setDisabled(!this._customizationEnabled);
        inputTag.setDynamicAttribute("", "labelOff", (Object)"not-customizable");
        inputTag.setDynamicAttribute("", "labelOn", (Object)"customizable");
        inputTag.setLabel("");
        inputTag.setName("TypeSettingsProperties--".concat(customizableKey).concat("--"));
        inputTag.setPageContext(this._pageContext);
        inputTag.setType("toggle-switch");
        inputTag.setValue((Object)customizable);
        int result = inputTag.doStartTag();
        if (result == 1) {
            inputTag.doEndTag();
        }
        this._writer.append("</div>");
        return "";
    }

    @Override
    public String processMax() throws Exception {
        return "";
    }

    @Override
    public String processPortlet(String portletId) throws Exception {
        this._writer.append("<div class=\"portlet\">");
        this._writer.append(portletId);
        this._writer.append("</div>");
        return "";
    }

    @Override
    public String processPortlet(String portletId, Map<String, ?> defaultSettingsMap) throws Exception {
        return this.processPortlet(portletId);
    }

    @Override
    public String processPortlet(String portletProviderClassName, PortletProvider.Action portletProviderAction) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)portletProviderClassName, (PortletProvider.Action)portletProviderAction);
        return this.processPortlet(portletId);
    }
}

