/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CommentCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileContentReference;
import com.liferay.portal.kernel.repository.model.ModelValidator;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.repository.util.ModelValidatorUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.ModelValidatorLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.ModelValidatorRepositoryWrapper;
import com.liferay.portal.util.PropsValues;

public class LiferayRepositoryDefiner
extends BaseRepositoryDefiner {
    public static final String CLASS_NAME = LiferayRepository.class.getName();
    @Deprecated
    protected PortalCapabilityLocator portalCapabilityLocator;
    private static volatile PortalCapabilityLocator _portalCapabilityLocator = (PortalCapabilityLocator)ServiceProxyFactory.newServiceTrackedInstance(PortalCapabilityLocator.class, LiferayRepositoryDefiner.class, (String)"_portalCapabilityLocator", (boolean)false, (boolean)true);
    private RepositoryFactory _repositoryFactory;

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean isExternalRepository() {
        return false;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        DocumentRepository documentRepository = (DocumentRepository)capabilityRegistry.getTarget();
        capabilityRegistry.addExportedCapability(BulkOperationCapability.class, (Capability)_portalCapabilityLocator.getBulkOperationCapability(documentRepository));
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            capabilityRegistry.addExportedCapability(CommentCapability.class, (Capability)_portalCapabilityLocator.getCommentCapability(documentRepository));
        }
        capabilityRegistry.addExportedCapability(RelatedModelCapability.class, (Capability)_portalCapabilityLocator.getRelatedModelCapability(documentRepository));
        capabilityRegistry.addExportedCapability(ThumbnailCapability.class, (Capability)_portalCapabilityLocator.getThumbnailCapability(documentRepository));
        capabilityRegistry.addExportedCapability(TrashCapability.class, (Capability)_portalCapabilityLocator.getTrashCapability(documentRepository));
        capabilityRegistry.addExportedCapability(WorkflowCapability.class, (Capability)_portalCapabilityLocator.getWorkflowCapability(documentRepository, WorkflowCapability.OperationMode.FULL));
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)_portalCapabilityLocator.getProcessorCapability(documentRepository, ProcessorCapability.ResourceGenerationStrategy.REUSE));
        capabilityRegistry.addSupportedCapability(SyncCapability.class, (Capability)_portalCapabilityLocator.getSyncCapability(documentRepository));
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }

    public void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        this._repositoryFactory = new LiferayRepositoryFactoryWrapper(repositoryFactory);
    }

    private static class LiferayRepositoryFactoryWrapper
    implements RepositoryFactory {
        private final RepositoryFactory _repositoryFactory;

        public LiferayRepositoryFactoryWrapper(RepositoryFactory repositoryFactory) {
            this._repositoryFactory = repositoryFactory;
        }

        public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
            LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
            ModelValidator modelValidator = ModelValidatorUtil.getDefaultDLFileEntryModelValidator();
            return new ModelValidatorLocalRepositoryWrapper(localRepository, (ModelValidator<FileContentReference>)modelValidator);
        }

        public Repository createRepository(long repositoryId) throws PortalException {
            Repository repository = this._repositoryFactory.createRepository(repositoryId);
            ModelValidator modelValidator = ModelValidatorUtil.getDefaultDLFileEntryModelValidator();
            return new ModelValidatorRepositoryWrapper(repository, (ModelValidator<FileContentReference>)modelValidator);
        }
    }
}

