/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.model.CustomAttributesDisplay;
import com.liferay.petra.content.ContentUtil;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.kernel.application.type.ApplicationType;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletContextFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletAppImpl;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.service.base.PortletLocalServiceBaseImpl;
import com.liferay.portal.servlet.ComboServlet;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.UndeployedPortlet;
import com.liferay.portlet.extra.config.ExtraPortletAppConfig;
import com.liferay.portlet.extra.config.ExtraPortletAppConfigRegistry;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.util.JS;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.portlet.PortletMode;
import javax.portlet.PreferencesValidator;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

public class PortletLocalServiceImpl
extends PortletLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletLocalServiceImpl.class);
    private static final Map<String, PortletApp> _portletApps = new ConcurrentHashMap<String, PortletApp>();
    private static volatile Map<String, String> _portletIdsByStrutsPath;
    private static final Map<String, Portlet> _portletsMap;
    private static final Map<Long, Map<String, Portlet>> _portletsMaps;
    private static final Map<ClassLoader, Configuration> _propertiesConfigurations;
    private final AtomicReference<String[]> _friendlyURLMapperRootPortletIds = new AtomicReference<String[]>(new String[0]);
    private ServiceTracker<FriendlyURLMapper, String[]> _serviceTracker;

    @Skip
    public void addPortletCategory(long companyId, String categoryName) {
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error((Object)("Unable to add portlet category for company " + companyId + " because it does not exist"));
            return;
        }
        PortletCategory newPortletCategory = new PortletCategory(categoryName);
        if (newPortletCategory.getParentCategory() == null) {
            PortletCategory rootPortletCategory = new PortletCategory();
            rootPortletCategory.addCategory(newPortletCategory);
        }
        portletCategory.merge(newPortletCategory.getRootCategory());
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=" + FriendlyURLMapper.class.getName() + ")");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void checkPortlet(Portlet portlet) throws PortalException {
        this.initPortletDefaultPermissions(portlet);
        this.initPortletRootModelDefaultPermissions(portlet);
        this.initPortletModelDefaultPermissions(portlet);
        this.initPortletAddToPagePermissions(portlet);
    }

    public void checkPortlets(long companyId) throws PortalException {
        List<Portlet> portlets = this.getPortlets(companyId);
        for (Portlet portlet : portlets) {
            this.checkPortlet(portlet);
        }
    }

    @Skip
    public void clearCache() {
        ComboServlet.clearCache();
        _portletIdsByStrutsPath = null;
        this.portletLocalService.clearPortletsMap();
    }

    @Clusterable
    @Deprecated
    @Transactional(enabled=false)
    public void clearCompanyPortletsPool() {
        _portletsMaps.clear();
    }

    @Clusterable
    @Transactional(enabled=false)
    public void clearPortletsMap() {
        _portletsMaps.clear();
    }

    @Skip
    public Portlet clonePortlet(String portletId) {
        Portlet portlet = this.getPortletById(portletId);
        return (Portlet)portlet.clone();
    }

    public void deletePortlet(long companyId, String portletId, long plid) throws PortalException {
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        this.resourceLocalService.deleteResource(companyId, rootPortletId, 4, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId));
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferences(plid, portletId);
        Portlet portlet = this.getPortletById(companyId, portletId);
        PortletLayoutListener portletLayoutListener = null;
        if (portlet != null) {
            portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            PortletInstanceFactoryUtil.delete((Portlet)portlet);
        }
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            if (portletLayoutListener != null) {
                portletLayoutListener.onRemoveFromLayout(portletPreferences.getPortletId(), plid);
            }
            this.portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
        }
    }

    public void deletePortlets(long companyId, String[] portletIds, long plid) throws PortalException {
        for (String portletId : portletIds) {
            this.deletePortlet(companyId, portletId, plid);
        }
    }

    @Skip
    public void deployPortlet(Portlet portlet) throws Exception {
        PortletApp portletApp = portlet.getPortletApp();
        _portletApps.put(portletApp.getServletContextName(), portletApp);
        ServletContext servletContext = portletApp.getServletContext();
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(ClassLoaderPool.getClassLoader((String)servletContext.getServletContextName()));
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        portletBagFactory.create(portlet, true);
        _portletsMap.put(portlet.getRootPortletId(), portlet);
        this.clearCache();
    }

    public Portlet deployRemotePortlet(Portlet portlet, String categoryName) throws PortalException {
        return this.deployRemotePortlet(portlet, new String[]{categoryName});
    }

    public Portlet deployRemotePortlet(Portlet portlet, String[] categoryNames) throws PortalException {
        return this.deployRemotePortlet(portlet, categoryNames, true);
    }

    public Portlet deployRemotePortlet(Portlet portlet, String[] categoryNames, boolean eagerDestroy) throws PortalException {
        ResourceActionsUtil.check((Portlet)portlet);
        _portletsMap.put(portlet.getPortletId(), portlet);
        if (eagerDestroy) {
            PortletInstanceFactoryUtil.clear((Portlet)portlet, (boolean)false);
            PortletConfigFactoryUtil.destroy((Portlet)portlet);
        }
        this.clearCache();
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(portlet.getCompanyId(), "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error((Object)("Unable to register remote portlet for company " + portlet.getCompanyId() + " because it does not exist"));
            return portlet;
        }
        portletCategory.separate(portlet.getPortletId());
        for (String categoryName : categoryNames) {
            PortletCategory newPortletCategory = new PortletCategory(categoryName);
            if (newPortletCategory.getParentCategory() == null) {
                PortletCategory rootPortletCategory = new PortletCategory();
                rootPortletCategory.addCategory(newPortletCategory);
            }
            Set portletIds = newPortletCategory.getPortletIds();
            portletIds.add(portlet.getPortletId());
            portletCategory.merge(newPortletCategory.getRootCategory());
        }
        this.checkPortlet(portlet);
        return portlet;
    }

    @Override
    public void destroy() {
        super.destroy();
        this._serviceTracker.close();
    }

    @Skip
    public void destroyPortlet(Portlet portlet) {
        _portletsMap.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp != null) {
            String servletContextName = portletApp.getServletContextName();
            _portletApps.remove(servletContextName);
            ExtraPortletAppConfigRegistry.unregisterExtraPortletAppConfig(servletContextName);
        }
        this.clearCache();
    }

    @Skip
    public void destroyRemotePortlet(Portlet portlet) {
        this.destroyPortlet(portlet);
    }

    @Skip
    public Portlet fetchPortletById(long companyId, String portletId) {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Map<String, Portlet> companyPortletsMap = this.getPortletsMap(companyId);
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        if (portletId.equals(rootPortletId)) {
            return companyPortletsMap.get(portletId);
        }
        Portlet portlet = companyPortletsMap.get(rootPortletId);
        if (portlet != null) {
            portlet = portlet.getClonedInstance(portletId);
        }
        return portlet;
    }

    @Skip
    public List<CustomAttributesDisplay> getCustomAttributesDisplays() {
        ArrayList<CustomAttributesDisplay> customAttributesDisplays = new ArrayList<CustomAttributesDisplay>();
        for (Portlet portlet : this.getPortlets()) {
            List portletCustomAttributesDisplays;
            if (!portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet() || (portletCustomAttributesDisplays = portlet.getCustomAttributesDisplayInstances()) == null || portletCustomAttributesDisplays.isEmpty()) continue;
            customAttributesDisplays.addAll(portletCustomAttributesDisplays);
        }
        return customAttributesDisplays;
    }

    @Skip
    public PortletCategory getEARDisplay(String xml) {
        try {
            return this.readLiferayDisplayXML(xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Skip
    public List<Portlet> getFriendlyURLMapperPortlets() {
        String[] friendlyURLMapperRootPortletIds = this._friendlyURLMapperRootPortletIds.get();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(friendlyURLMapperRootPortletIds.length);
        for (String rootPortletId : friendlyURLMapperRootPortletIds) {
            Portlet portlet = _portletsMap.get(rootPortletId);
            if (portlet == null || !portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet()) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    @Skip
    public List<FriendlyURLMapper> getFriendlyURLMappers() {
        ArrayList<FriendlyURLMapper> friendlyURLMappers = new ArrayList<FriendlyURLMapper>();
        for (Portlet portlet : this.getPortlets()) {
            FriendlyURLMapper friendlyURLMapper;
            if (!portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet() || (friendlyURLMapper = portlet.getFriendlyURLMapperInstance()) == null) continue;
            friendlyURLMappers.add(friendlyURLMapper);
        }
        return friendlyURLMappers;
    }

    @Skip
    public PortletApp getPortletApp(String servletContextName) {
        PortletApp portletApp = _portletApps.get(servletContextName);
        if (portletApp == null) {
            portletApp = new PortletAppImpl(servletContextName);
            _portletApps.put(servletContextName, portletApp);
        }
        return portletApp;
    }

    @Skip
    public Portlet getPortletById(long companyId, String portletId) {
        Portlet portlet = this.fetchPortletById(companyId, portletId);
        if (portlet != null) {
            return portlet;
        }
        if (portletId.equals("LIFERAY_PORTAL")) {
            return portlet;
        }
        if (_portletsMap.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No portlets are installed");
            }
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Portlet not found for ", String.valueOf(companyId), " ", portletId}));
            }
            portlet = new PortletImpl(0L, portletId);
            PortletApp portletApp = this.getPortletApp("");
            portlet.setPortletApp(portletApp);
            portlet.setPortletName(portletId);
            portlet.setDisplayName(portletId);
            portlet.setPortletClass(UndeployedPortlet.class.getName());
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(StringUtil.toLowerCase((String)PortletMode.VIEW.toString()));
            Map portletModes = portlet.getPortletModes();
            portletModes.put("text/html", mimeTypePortletModes);
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.NORMAL.toString()));
            Map windowStates = portlet.getWindowStates();
            windowStates.put("text/html", mimeTypeWindowStates);
            portlet.setPortletInfo(new PortletInfo(portletId, portletId, portletId, portletId));
            if (PortletIdCodec.hasInstanceId((String)portletId)) {
                portlet.setInstanceable(true);
            }
            portlet.setActive(true);
            portlet.setUndeployedPortlet(true);
        }
        return portlet;
    }

    @Skip
    public Portlet getPortletById(String portletId) {
        return _portletsMap.get(PortletIdCodec.decodePortletName((String)portletId));
    }

    @Skip
    public Portlet getPortletByStrutsPath(long companyId, String strutsPath) {
        String portletId = this.getPortletId(strutsPath);
        if (portletId == null) {
            return null;
        }
        return this.getPortletById(companyId, portletId);
    }

    @Skip
    public List<Portlet> getPortlets() {
        return ListUtil.fromMapValues(_portletsMap);
    }

    @Skip
    public List<Portlet> getPortlets(long companyId) {
        return this.getPortlets(companyId, true, true);
    }

    @Skip
    public List<Portlet> getPortlets(long companyId, boolean showSystem, boolean showPortal) {
        Map<String, Portlet> portletsMap = this.getPortletsMap(companyId);
        List portlets = ListUtil.fromMapValues(portletsMap);
        if (showSystem && showPortal) {
            return portlets;
        }
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            String portletId = portlet.getPortletId();
            if (showPortal && portletId.equals("90")) continue;
            if (!showPortal && portletId.equals("90")) {
                itr.remove();
                continue;
            }
            if (showSystem || !portlet.isSystem()) continue;
            itr.remove();
        }
        return portlets;
    }

    public int getPortletsCount(long companyId) {
        return this.portletPersistence.countByCompanyId(companyId);
    }

    @Skip
    public List<Portlet> getScopablePortlets() {
        List portlets = ListUtil.fromMapValues(_portletsMap);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (portlet.isScopeable()) continue;
            itr.remove();
        }
        return portlets;
    }

    @Skip
    public PortletCategory getWARDisplay(String servletContextName, String xml) {
        try {
            return this.readLiferayDisplayXML(servletContextName, xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Skip
    public boolean hasPortlet(long companyId, String portletId) {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsMap = this.getPortletsMap(companyId);
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        portlet = portletId.equals(rootPortletId) ? companyPortletsMap.get(portletId) : companyPortletsMap.get(rootPortletId);
        return portlet != null;
    }

    @Skip
    public void initEAR(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        this.portletLocalService.clearPortletsMap();
        _portletApps.clear();
        _portletsMap.clear();
        try {
            PortletApp portletApp = this.getPortletApp("");
            portletApp.setServletContext(servletContext);
            Set<String> servletURLPatterns = this.readWebXML(xmls[4]);
            this._readWebXML(xmls[4], portletApp.getServletContextName());
            Map<String, Portlet> portletsMap = this.readPortletXML("", servletContext, xmls[0], servletURLPatterns, pluginPackage);
            portletsMap.putAll(this.readPortletXML("", servletContext, xmls[1], servletURLPatterns, pluginPackage));
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                _portletsMap.put(entry.getKey(), entry.getValue());
            }
            ConcurrentHashMap<String, String> portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
            Set<String> liferayPortletIds = this.readLiferayPortletXML("", servletContext, xmls[2], portletsMap, portletIdsByStrutsPath);
            liferayPortletIds.addAll(this.readLiferayPortletXML("", servletContext, xmls[3], portletsMap, portletIdsByStrutsPath));
            _portletIdsByStrutsPath = portletIdsByStrutsPath;
            for (String portletId : portletsMap.keySet()) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Portlet with the name ", portletId, " is described in portlet.xml but does not have a ", "matching entry in liferay-portlet.xml"}));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletsMap.containsKey(portletId)) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Portlet with the name ", portletId, " is described in liferay-portlet.xml but does ", "not have a matching entry in portlet.xml"}));
            }
            Set<Map.Entry<String, Portlet>> entrySet = _portletsMap.entrySet();
            Iterator<Map.Entry<String, Portlet>> portletPoolsItr = entrySet.iterator();
            while (portletPoolsItr.hasNext()) {
                Map.Entry<String, Portlet> entry = portletPoolsItr.next();
                Portlet portletModel = entry.getValue();
                String portletId = PortletProviderUtil.getPortletId((String)"com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", (PortletProvider.Action)PortletProvider.Action.VIEW);
                if (Objects.equals(portletModel.getPortletId(), "com_liferay_server_admin_web_portlet_ServerAdminPortlet") || Objects.equals(portletModel.getPortletId(), portletId) || portletModel.isInclude()) continue;
                portletPoolsItr.remove();
            }
            this.setSpriteImages(servletContext, portletApp, "/html/icons/");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Skip
    public List<Portlet> initWAR(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        Map<String, Portlet> portletsMap = null;
        Set<String> liferayPortletIds = null;
        try {
            void var8_12;
            Set<String> servletURLPatterns = this.readWebXML(xmls[3]);
            this._readWebXML(xmls[3], servletContextName);
            portletsMap = this.readPortletXML(servletContextName, servletContext, xmls[0], servletURLPatterns, pluginPackage);
            portletsMap.putAll(this.readPortletXML(servletContextName, servletContext, xmls[1], servletURLPatterns, pluginPackage));
            Map<String, String> map = _portletIdsByStrutsPath;
            if (map == null) {
                HashMap hashMap = new HashMap();
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
            }
            liferayPortletIds = this.readLiferayPortletXML(servletContextName, servletContext, xmls[2], portletsMap, (Map<String, String>)var8_12);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
        for (String string : portletsMap.keySet()) {
            if (!_log.isWarnEnabled() || liferayPortletIds.contains(string)) continue;
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Portlet with the name ", string, " is described in portlet.xml but does not have a ", "matching entry in liferay-portlet.xml"}));
        }
        for (String string : liferayPortletIds) {
            if (!_log.isWarnEnabled() || portletsMap.containsKey(string)) continue;
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Portlet with the name ", string, " is described in liferay-portlet.xml but does not ", "have a matching entry in portlet.xml"}));
        }
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(ClassLoaderPool.getClassLoader((String)servletContextName));
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        try {
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                Portlet portlet = _portletsMap.remove(entry.getKey());
                if (portlet != null) {
                    PortletInstanceFactoryUtil.clear((Portlet)portlet);
                    PortletConfigFactoryUtil.destroy((Portlet)portlet);
                    PortletContextFactoryUtil.destroy((Portlet)portlet);
                }
                portlet = entry.getValue();
                portletBagFactory.create(portlet, true);
                _portletsMap.put(entry.getKey(), portlet);
            }
            PortletApp portletApp = this.getPortletApp(servletContextName);
            this.setSpriteImages(servletContext, portletApp, "/icons/");
            List list = ListUtil.fromMapValues(portletsMap);
            return list;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                Portlet portlet = _portletsMap.remove(entry.getKey());
                if (portlet == null) continue;
                PortletInstanceFactoryUtil.clear((Portlet)portlet);
                PortletConfigFactoryUtil.destroy((Portlet)portlet);
                PortletContextFactoryUtil.destroy((Portlet)portlet);
            }
            List<Portlet> list = Collections.emptyList();
            return list;
        }
        finally {
            this.clearCache();
        }
    }

    public Map<String, Portlet> loadGetPortletsMap(long companyId) {
        ConcurrentHashMap<String, Portlet> portletsMap = new ConcurrentHashMap<String, Portlet>();
        for (Portlet portlet : _portletsMap.values()) {
            portlet = (Portlet)portlet.clone();
            portlet.setCompanyId(companyId);
            portletsMap.put(portlet.getPortletId(), portlet);
        }
        List portlets = this.portletPersistence.findByCompanyId(companyId);
        for (Portlet portlet : portlets) {
            Portlet portletModel = (Portlet)portletsMap.get(portlet.getPortletId());
            if (portletModel == null) continue;
            portletModel.setPluginPackage(portlet.getPluginPackage());
            portletModel.setDefaultPluginSetting(portlet.getDefaultPluginSetting());
            portletModel.setRoles(portlet.getRoles());
            portletModel.setActive(portlet.getActive());
        }
        return portletsMap;
    }

    @Deprecated
    public Map<String, Portlet> loadGetPortletsPool(long companyId) {
        return this.loadGetPortletsMap(companyId);
    }

    @Clusterable
    @Transactional(enabled=false)
    public void removeCompanyPortletsPool(long companyId) {
        _portletsMaps.remove(companyId);
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) {
        Portlet portlet = this.portletPersistence.fetchByC_P(companyId, portletId = PortalUtil.getJsSafePortletId((String)portletId));
        if (portlet == null) {
            long id = this.counterLocalService.increment();
            portlet = this.portletPersistence.create(id);
            portlet.setCompanyId(companyId);
            portlet.setPortletId(portletId);
        }
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletPersistence.update((BaseModel)portlet);
        portlet = this.getPortletById(companyId, portletId);
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletLocalService.removeCompanyPortletsPool(companyId);
        return portlet;
    }

    @Skip
    public void visitPortlets(long companyId, Consumer<Portlet> consumer) {
        Map<String, Portlet> portletsMap = this.getPortletsMap(companyId);
        for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
            consumer.accept(entry.getValue());
        }
    }

    protected String getPortletId(String securityPath) {
        String portletId;
        Map<String, String> portletIdsByStrutsPath = _portletIdsByStrutsPath;
        if (portletIdsByStrutsPath == null) {
            portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
            for (Portlet portlet : _portletsMap.values()) {
                String strutsPath = portlet.getStrutsPath();
                String oldPortletId = portletIdsByStrutsPath.put(strutsPath, portlet.getPortletId());
                if (oldPortletId == null || !_log.isWarnEnabled()) continue;
                _log.warn((Object)("Duplicate struts path " + strutsPath));
            }
            _portletIdsByStrutsPath = portletIdsByStrutsPath;
        }
        if (Validator.isNull((String)(portletId = portletIdsByStrutsPath.get(securityPath)))) {
            for (Map.Entry<String, String> entry : portletIdsByStrutsPath.entrySet()) {
                String strutsPath = entry.getKey();
                if (!securityPath.startsWith(strutsPath.concat("/"))) continue;
                portletId = entry.getValue();
                break;
            }
        }
        if (Validator.isNull((String)portletId)) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Struts path ", securityPath, " is not mapped to a portlet in liferay-portlet.xml"}));
        }
        return portletId;
    }

    protected List<Portlet> getPortletsByPortletName(String portletName, String servletContextName, Map<String, Portlet> portletsMap) {
        int pos = portletName.indexOf(42);
        if (pos == -1) {
            Portlet portlet;
            String portletId = portletName;
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId + "_WAR_" + servletContextName;
            }
            if ((portlet = portletsMap.get(portletId = PortalUtil.getJsSafePortletId((String)portletId))) == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(portlet);
        }
        return this.getPortletsByServletContextName(servletContextName, portletName.substring(0, pos), portletsMap);
    }

    protected List<Portlet> getPortletsByServletContextName(String servletContextName, String portletNamePrefix, Map<String, Portlet> portletsMap) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        String servletContextNameSuffix = null;
        if (Validator.isNotNull((String)servletContextName)) {
            servletContextNameSuffix = PortalUtil.getJsSafePortletId((String)"_WAR_".concat(servletContextName));
        }
        for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
            String portletId = entry.getKey();
            if (!portletId.startsWith(portletNamePrefix)) continue;
            if (servletContextNameSuffix == null) {
                if (portletId.contains("_WAR_")) continue;
                portlets.add(entry.getValue());
                continue;
            }
            if (!portletId.endsWith(servletContextNameSuffix)) continue;
            portlets.add(entry.getValue());
        }
        return portlets;
    }

    protected Map<String, Portlet> getPortletsMap(long companyId) {
        Map portletsMap = _portletsMaps.get(companyId);
        if (portletsMap == null) {
            portletsMap = this.portletLocalService.loadGetPortletsMap(companyId);
            _portletsMaps.put(companyId, portletsMap);
        }
        return portletsMap;
    }

    protected String getTriggerValue(Portlet portlet, String propertyKey) {
        PortletApp portletApp = portlet.getPortletApp();
        ServletContext servletContext = portletApp.getServletContext();
        ClassLoader classLoader = servletContext.getClassLoader();
        Configuration configuration = _propertiesConfigurations.get(classLoader);
        if (configuration == null) {
            String propertyFileName = "portal";
            if (portletApp.isWARFile()) {
                propertyFileName = "portlet";
            }
            configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)propertyFileName);
            _propertiesConfigurations.put(classLoader, configuration);
        }
        return configuration.get(propertyKey);
    }

    protected void initPortletAddToPagePermissions(Portlet portlet) throws PortalException {
        if (portlet.isSystem()) {
            return;
        }
        String[] roleNames = portlet.getRolesArray();
        Portlet existingPortlet = this.portletPersistence.fetchByC_P(portlet.getCompanyId(), portlet.getPortletId());
        if (existingPortlet != null) {
            roleNames = existingPortlet.getRolesArray();
        }
        if (roleNames.length == 0) {
            return;
        }
        List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portlet.getRootPortletId());
        if (actionIds.contains("ADD_TO_PAGE")) {
            List guestUnsupportedActionIds = ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)portlet.getRootPortletId());
            boolean skipGuestRole = guestUnsupportedActionIds.contains("ADD_TO_PAGE");
            for (String roleName : roleNames) {
                if (skipGuestRole && roleName.equals("Guest")) continue;
                Role role = this.roleLocalService.getRole(portlet.getCompanyId(), roleName);
                this.resourcePermissionLocalService.addResourcePermission(portlet.getCompanyId(), portlet.getRootPortletId(), 1, String.valueOf(portlet.getCompanyId()), role.getRoleId(), "ADD_TO_PAGE");
            }
        }
        this.updatePortlet(portlet.getCompanyId(), portlet.getPortletId(), "");
    }

    protected void initPortletDefaultPermissions(Portlet portlet) throws PortalException {
        Role guestRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Guest");
        List guestActions = ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)portlet.getRootPortletId());
        this.resourcePermissionLocalService.setResourcePermissions(portlet.getCompanyId(), portlet.getRootPortletId(), 4, portlet.getRootPortletId(), guestRole.getRoleId(), guestActions.toArray(new String[0]));
        Role ownerRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Owner");
        List ownerActionIds = ResourceActionsUtil.getPortletResourceActions((String)portlet.getRootPortletId());
        this.resourcePermissionLocalService.setOwnerResourcePermissions(portlet.getCompanyId(), portlet.getRootPortletId(), 4, portlet.getRootPortletId(), ownerRole.getRoleId(), 0L, ownerActionIds.toArray(new String[0]));
        Role siteMemberRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Site Member");
        List groupActionIds = ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)portlet.getRootPortletId());
        this.resourcePermissionLocalService.setResourcePermissions(portlet.getCompanyId(), portlet.getRootPortletId(), 4, portlet.getRootPortletId(), siteMemberRole.getRoleId(), groupActionIds.toArray(new String[0]));
    }

    protected void initPortletModelDefaultPermissions(Portlet portlet) throws PortalException {
        ArrayList<String> modelResources = new ArrayList<String>();
        modelResources.add(ResourceActionsUtil.getPortletRootModelResource((String)portlet.getRootPortletId()));
        modelResources.addAll(ResourceActionsUtil.getPortletModelResources((String)portlet.getRootPortletId()));
        for (String modelResource : modelResources) {
            if (Validator.isBlank((String)modelResource)) continue;
            this.resourceLocalService.addResources(portlet.getCompanyId(), 0L, 0L, modelResource, modelResource, false, false, true);
        }
    }

    protected void initPortletRootModelDefaultPermissions(Portlet portlet) throws PortalException {
        String rootModelResource = ResourceActionsUtil.getPortletRootModelResource((String)portlet.getRootPortletId());
        if (Validator.isBlank((String)rootModelResource)) {
            return;
        }
        Role guestRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Guest");
        List guestActionIds = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)rootModelResource);
        this.resourcePermissionLocalService.setResourcePermissions(portlet.getCompanyId(), rootModelResource, 4, rootModelResource, guestRole.getRoleId(), guestActionIds.toArray(new String[0]));
        Role ownerRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Owner");
        List ownerActionIds = ResourceActionsUtil.getModelResourceActions((String)rootModelResource);
        this.resourcePermissionLocalService.setOwnerResourcePermissions(portlet.getCompanyId(), rootModelResource, 4, rootModelResource, ownerRole.getRoleId(), 0L, ownerActionIds.toArray(new String[0]));
        Role siteMemberRole = this.roleLocalService.getRole(portlet.getCompanyId(), "Site Member");
        List groupActionIds = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)rootModelResource);
        this.resourcePermissionLocalService.setResourcePermissions(portlet.getCompanyId(), rootModelResource, 4, rootModelResource, siteMemberRole.getRoleId(), groupActionIds.toArray(new String[0]));
    }

    protected void readLiferayDisplay(String servletContextName, Element element, PortletCategory portletCategory, Set<String> portletIds) {
        for (Element categoryElement : element.elements("category")) {
            String name = categoryElement.attributeValue("name");
            PortletCategory curPortletCategory = new PortletCategory(name);
            portletCategory.addCategory(curPortletCategory);
            Set curPortletIds = curPortletCategory.getPortletIds();
            for (Element portletElement : categoryElement.elements("portlet")) {
                String portletId = portletElement.attributeValue("id");
                if (Validator.isNotNull((String)servletContextName)) {
                    portletId = portletId + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId((String)portletId);
                portletIds.add(portletId);
                curPortletIds.add(portletId);
            }
            this.readLiferayDisplay(servletContextName, categoryElement, curPortletCategory, portletIds);
        }
    }

    protected PortletCategory readLiferayDisplayXML(String xml) throws Exception {
        return this.readLiferayDisplayXML(null, xml);
    }

    protected PortletCategory readLiferayDisplayXML(String servletContextName, String xml) throws Exception {
        PortletCategory portletCategory = new PortletCategory();
        if (xml == null) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            xml = ContentUtil.get((ClassLoader)clazz.getClassLoader(), (String)"com/liferay/portal/deploy/dependencies/liferay-display.xml");
        }
        Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        HashSet<String> portletIds = new HashSet<String>();
        this.readLiferayDisplay(servletContextName, rootElement, portletCategory, portletIds);
        HashSet<String> undefinedPortletIds = new HashSet<String>();
        for (Portlet portlet : _portletsMap.values()) {
            String portletId = portlet.getPortletId();
            PortletApp portletApp = portlet.getPortletApp();
            if (servletContextName != null && portletApp.isWARFile() && portletId.endsWith("_WAR_" + PortalUtil.getJsSafePortletId((String)servletContextName)) && !portletIds.contains(portletId)) {
                undefinedPortletIds.add(portletId);
                continue;
            }
            if (servletContextName != null || portletApp.isWARFile() || portletId.contains("_WAR_") || portletIds.contains(portletId)) continue;
            undefinedPortletIds.add(portletId);
        }
        if (!undefinedPortletIds.isEmpty()) {
            PortletCategory undefinedCategory = new PortletCategory("category.undefined");
            portletCategory.addCategory(undefinedCategory);
            Set undefinedCategoryPortletIds = undefinedCategory.getPortletIds();
            undefinedCategoryPortletIds.addAll(undefinedPortletIds);
        }
        return portletCategory;
    }

    protected void readLiferayPortletXML(String servletContextName, ServletContext servletContext, Set<String> liferayPortletIds, Map<String, String> roleMappers, Element portletElement, Map<String, Portlet> portletsMap, Map<String, String> portletIdsByStrutsPath) {
        String oldPortletId;
        String portletId = portletElement.elementText("portlet-name");
        if (Validator.isNotNull((String)servletContextName)) {
            portletId = portletId.concat("_WAR_").concat(servletContextName);
        }
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading portlet extension " + portletId));
        }
        liferayPortletIds.add(portletId);
        Portlet portletModel = portletsMap.get(portletId);
        if (portletModel == null) {
            return;
        }
        portletModel.setIcon(GetterUtil.getString((String)portletElement.elementText("icon"), (String)portletModel.getIcon()));
        portletModel.setVirtualPath(GetterUtil.getString((String)portletElement.elementText("virtual-path"), (String)portletModel.getVirtualPath()));
        portletModel.setStrutsPath(GetterUtil.getString((String)portletElement.elementText("struts-path"), (String)portletModel.getStrutsPath()));
        String strutsPath = portletModel.getStrutsPath();
        if (Validator.isNotNull((String)strutsPath) && (oldPortletId = portletIdsByStrutsPath.put(strutsPath, portletId)) != null && !oldPortletId.equals(portletId) && _log.isWarnEnabled()) {
            _log.warn((Object)("Duplicate struts path " + strutsPath));
        }
        portletModel.setParentStrutsPath(GetterUtil.getString((String)portletElement.elementText("parent-struts-path"), (String)portletModel.getParentStrutsPath()));
        if (Validator.isNotNull((String)portletElement.elementText("configuration-path"))) {
            _log.error((Object)"The configuration-path element is no longer supported. Use configuration-action-class instead.");
        }
        portletModel.setConfigurationActionClass(GetterUtil.getString((String)portletElement.elementText("configuration-action-class"), (String)portletModel.getConfigurationActionClass()));
        ArrayList<String> indexerClasses = new ArrayList<String>();
        for (Element indexerClassElement : portletElement.elements("indexer-class")) {
            indexerClasses.add(indexerClassElement.getText());
        }
        portletModel.setIndexerClasses(indexerClasses);
        portletModel.setOpenSearchClass(GetterUtil.getString((String)portletElement.elementText("open-search-class"), (String)portletModel.getOpenSearchClass()));
        for (Object schedulerEntryElement : portletElement.elements("scheduler-entry")) {
            Element propertyKeyElement;
            String description = GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-description"));
            String eventListenerClass = GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-event-listener-class"));
            Trigger trigger = null;
            Element triggerElement = schedulerEntryElement.element("trigger");
            Element cronElement = triggerElement.element("cron");
            Element simpleElement = triggerElement.element("simple");
            if (cronElement != null) {
                propertyKeyElement = cronElement.element("property-key");
                String cronException = null;
                cronException = propertyKeyElement != null ? this.getTriggerValue(portletModel, propertyKeyElement.getTextTrim()) : cronElement.elementText("cron-trigger-value");
                trigger = TriggerFactoryUtil.createTrigger((String)eventListenerClass, (String)eventListenerClass, (String)cronException);
            } else if (simpleElement != null) {
                propertyKeyElement = simpleElement.element("property-key");
                String intervalString = null;
                if (propertyKeyElement != null) {
                    intervalString = this.getTriggerValue(portletModel, propertyKeyElement.getTextTrim());
                } else {
                    Element simpleTriggerValueElement = simpleElement.element("simple-trigger-value");
                    intervalString = simpleTriggerValueElement.getTextTrim();
                }
                String timeUnitString = StringUtil.toUpperCase((String)GetterUtil.getString((String)simpleElement.elementText("time-unit"), (String)TimeUnit.SECOND.getValue()));
                trigger = TriggerFactoryUtil.createTrigger((String)eventListenerClass, (String)eventListenerClass, (int)GetterUtil.getIntegerStrict((String)intervalString), (TimeUnit)TimeUnit.valueOf((String)timeUnitString));
            }
            SchedulerEntryImpl schedulerEntryImpl = new SchedulerEntryImpl(eventListenerClass, trigger, description);
            portletModel.addSchedulerEntry((SchedulerEntry)schedulerEntryImpl);
        }
        portletModel.setPortletURLClass(GetterUtil.getString((String)portletElement.elementText("portlet-url-class"), (String)portletModel.getPortletURLClass()));
        portletModel.setFriendlyURLMapperClass(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapper-class"), (String)portletModel.getFriendlyURLMapperClass()));
        portletModel.setFriendlyURLMapping(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapping"), (String)portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString((String)portletElement.elementText("friendly-url-routes"), (String)portletModel.getFriendlyURLRoutes()));
        portletModel.setURLEncoderClass(GetterUtil.getString((String)portletElement.elementText("url-encoder-class"), (String)portletModel.getURLEncoderClass()));
        portletModel.setPortletDataHandlerClass(GetterUtil.getString((String)portletElement.elementText("portlet-data-handler-class"), (String)portletModel.getPortletDataHandlerClass()));
        ArrayList<String> stagedModelDataHandlerClasses = new ArrayList<String>();
        for (Object stagedModelDataHandlerClassElement : portletElement.elements("staged-model-data-handler-class")) {
            stagedModelDataHandlerClasses.add(stagedModelDataHandlerClassElement.getText());
        }
        portletModel.setStagedModelDataHandlerClasses(stagedModelDataHandlerClasses);
        portletModel.setTemplateHandlerClass(GetterUtil.getString((String)portletElement.elementText("template-handler"), (String)portletModel.getTemplateHandlerClass()));
        portletModel.setPortletLayoutListenerClass(GetterUtil.getString((String)portletElement.elementText("portlet-layout-listener-class"), (String)portletModel.getPortletLayoutListenerClass()));
        portletModel.setPollerProcessorClass(GetterUtil.getString((String)portletElement.elementText("poller-processor-class"), (String)portletModel.getPollerProcessorClass()));
        portletModel.setPopMessageListenerClass(GetterUtil.getString((String)portletElement.elementText("pop-message-listener-class"), (String)portletModel.getPopMessageListenerClass()));
        ArrayList<String> socialActivityInterpreterClasses = new ArrayList<String>();
        for (Object socialActivityInterpreterClassElement : portletElement.elements("social-activity-interpreter-class")) {
            socialActivityInterpreterClasses.add(socialActivityInterpreterClassElement.getText());
        }
        portletModel.setSocialActivityInterpreterClasses(socialActivityInterpreterClasses);
        portletModel.setSocialRequestInterpreterClass(GetterUtil.getString((String)portletElement.elementText("social-request-interpreter-class"), (String)portletModel.getSocialRequestInterpreterClass()));
        portletModel.setUserNotificationDefinitions(GetterUtil.getString((String)portletElement.elementText("user-notification-definitions"), (String)portletModel.getUserNotificationDefinitions()));
        ArrayList<String> userNotificationHandlerClasses = new ArrayList<String>();
        for (Object userNotificationHandlerClassElement : portletElement.elements("user-notification-handler-class")) {
            userNotificationHandlerClasses.add(userNotificationHandlerClassElement.getText());
        }
        portletModel.setUserNotificationHandlerClasses(userNotificationHandlerClasses);
        portletModel.setWebDAVStorageToken(GetterUtil.getString((String)portletElement.elementText("webdav-storage-token"), (String)portletModel.getWebDAVStorageToken()));
        portletModel.setWebDAVStorageClass(GetterUtil.getString((String)portletElement.elementText("webdav-storage-class"), (String)portletModel.getWebDAVStorageClass()));
        portletModel.setXmlRpcMethodClass(GetterUtil.getString((String)portletElement.elementText("xml-rpc-method-class"), (String)portletModel.getXmlRpcMethodClass()));
        HashSet<ApplicationType> applicationTypes = new HashSet<ApplicationType>();
        for (Object applicationTypeElement : portletElement.elements("application-type")) {
            try {
                applicationTypes.add(ApplicationType.parse((String)applicationTypeElement.getText()));
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unknown application type " + applicationTypeElement.getText()));
            }
        }
        if (applicationTypes.isEmpty()) {
            applicationTypes.add(ApplicationType.WIDGET);
        }
        portletModel.setApplicationTypes(applicationTypes);
        portletModel.setControlPanelEntryClass(GetterUtil.getString((String)portletElement.elementText("control-panel-entry-class"), (String)portletModel.getControlPanelEntryClass()));
        ArrayList<String> assetRendererFactoryClasses = new ArrayList<String>();
        for (Object assetRendererFactoryClassElement : portletElement.elements("asset-renderer-factory")) {
            assetRendererFactoryClasses.add(assetRendererFactoryClassElement.getText());
        }
        portletModel.setAssetRendererFactoryClasses(assetRendererFactoryClasses);
        ArrayList<String> atomCollectionAdapterClasses = new ArrayList<String>();
        for (Object atomCollectionAdapterClassElement : portletElement.elements("atom-collection-adapter")) {
            atomCollectionAdapterClasses.add(atomCollectionAdapterClassElement.getText());
        }
        portletModel.setAtomCollectionAdapterClasses(atomCollectionAdapterClasses);
        ArrayList<String> customAttributesDisplayClasses = new ArrayList<String>();
        for (Object customAttributesDisplayClassElement : portletElement.elements("custom-attributes-display")) {
            customAttributesDisplayClasses.add(customAttributesDisplayClassElement.getText());
        }
        portletModel.setCustomAttributesDisplayClasses(customAttributesDisplayClasses);
        portletModel.setPermissionPropagatorClass(GetterUtil.getString((String)portletElement.elementText("permission-propagator"), (String)portletModel.getPermissionPropagatorClass()));
        ArrayList<String> trashHandlerClasses = new ArrayList<String>();
        for (Object trashHandlerClassElement : portletElement.elements("trash-handler")) {
            trashHandlerClasses.add(trashHandlerClassElement.getText());
        }
        portletModel.setTrashHandlerClasses(trashHandlerClasses);
        ArrayList<String> workflowHandlerClasses = new ArrayList<String>();
        for (Element workflowHandlerClassElement : portletElement.elements("workflow-handler")) {
            workflowHandlerClasses.add(workflowHandlerClassElement.getText());
        }
        portletModel.setWorkflowHandlerClasses(workflowHandlerClasses);
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((String)portletElement.elementText("preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((String)portletElement.elementText("preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((String)portletElement.elementText("preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((String)portletElement.elementText("use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean((String)portletElement.elementText("action-url-redirect"), (boolean)portletModel.isActionURLRedirect()));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean((String)portletElement.elementText("restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean((String)portletElement.elementText("maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean((String)portletElement.elementText("maximize-help"), (boolean)portletModel.isMaximizeHelp()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean((String)portletElement.elementText("pop-up-print"), (boolean)portletModel.isPopUpPrint()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean((String)portletElement.elementText("layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
        portletModel.setInstanceable(GetterUtil.getBoolean((String)portletElement.elementText("instanceable"), (boolean)portletModel.isInstanceable()));
        portletModel.setRemoteable(GetterUtil.getBoolean((String)portletElement.elementText("remoteable"), (boolean)portletModel.isRemoteable()));
        portletModel.setScopeable(GetterUtil.getBoolean((String)portletElement.elementText("scopeable"), (boolean)portletModel.isScopeable()));
        portletModel.setSinglePageApplication(GetterUtil.getBoolean((String)portletElement.elementText("single-page-application"), (boolean)portletModel.isSinglePageApplication()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString((String)portletElement.elementText("user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
        Element autopropagatedParametersElement = portletElement.element("autopropagated-parameters");
        HashSet<String> autopropagatedParameters = new HashSet<String>();
        if (autopropagatedParametersElement != null) {
            String[] autopropagatedParametersArray;
            for (String autopropagatedParameter : autopropagatedParametersArray = StringUtil.split((String)autopropagatedParametersElement.getText())) {
                autopropagatedParameters.add(autopropagatedParameter);
            }
        }
        portletModel.setAutopropagatedParameters(autopropagatedParameters);
        boolean defaultRequiresNamespacedParameters = GetterUtil.getBoolean((String)servletContext.getInitParameter("com.liferay.portlet.requires-namespaced-parameters"), (boolean)portletModel.isRequiresNamespacedParameters());
        portletModel.setRequiresNamespacedParameters(GetterUtil.getBoolean((String)portletElement.elementText("requires-namespaced-parameters"), (boolean)defaultRequiresNamespacedParameters));
        portletModel.setActionTimeout(GetterUtil.getInteger((String)portletElement.elementText("action-timeout"), (int)portletModel.getActionTimeout()));
        portletModel.setRenderTimeout(GetterUtil.getInteger((String)portletElement.elementText("render-timeout"), (int)portletModel.getRenderTimeout()));
        portletModel.setRenderWeight(GetterUtil.getInteger((String)portletElement.elementText("render-weight"), (int)portletModel.getRenderWeight()));
        portletModel.setAjaxable(GetterUtil.getBoolean((String)portletElement.elementText("ajaxable"), (boolean)portletModel.isAjaxable()));
        ArrayList<String> headerPortalCssList = new ArrayList<String>();
        for (Element headerPortalCssElement : portletElement.elements("header-portal-css")) {
            headerPortalCssList.add(headerPortalCssElement.getText());
        }
        portletModel.setHeaderPortalCss(headerPortalCssList);
        ArrayList<String> headerPortletCssList = new ArrayList<String>();
        for (Object headerPortletCssElement : portletElement.elements("header-portlet-css")) {
            headerPortletCssList.add(headerPortletCssElement.getText());
        }
        portletModel.setHeaderPortletCss(headerPortletCssList);
        ArrayList<String> headerPortalJavaScriptList = new ArrayList<String>();
        for (Object headerPortalJavaScriptElement : portletElement.elements("header-portal-javascript")) {
            headerPortalJavaScriptList.add(headerPortalJavaScriptElement.getText());
        }
        portletModel.setHeaderPortalJavaScript(headerPortalJavaScriptList);
        ArrayList<String> headerPortletJavaScriptList = new ArrayList<String>();
        for (Object headerPortletJavaScriptElement : portletElement.elements("header-portlet-javascript")) {
            headerPortletJavaScriptList.add(headerPortletJavaScriptElement.getText());
        }
        portletModel.setHeaderPortletJavaScript(headerPortletJavaScriptList);
        ArrayList<String> footerPortalCssList = new ArrayList<String>();
        for (Object footerPortalCssElement : portletElement.elements("footer-portal-css")) {
            footerPortalCssList.add(footerPortalCssElement.getText());
        }
        portletModel.setFooterPortalCss(footerPortalCssList);
        ArrayList<String> footerPortletCssList = new ArrayList<String>();
        for (Object footerPortletCssElement : portletElement.elements("footer-portlet-css")) {
            footerPortletCssList.add(footerPortletCssElement.getText());
        }
        portletModel.setFooterPortletCss(footerPortletCssList);
        ArrayList<String> footerPortalJavaScriptList = new ArrayList<String>();
        for (Object footerPortalJavaScriptElement : portletElement.elements("footer-portal-javascript")) {
            footerPortalJavaScriptList.add(footerPortalJavaScriptElement.getText());
        }
        portletModel.setFooterPortalJavaScript(footerPortalJavaScriptList);
        ArrayList<String> footerPortletJavaScriptList = new ArrayList<String>();
        for (Element footerPortletJavaScriptElement : portletElement.elements("footer-portlet-javascript")) {
            footerPortletJavaScriptList.add(footerPortletJavaScriptElement.getText());
        }
        portletModel.setFooterPortletJavaScript(footerPortletJavaScriptList);
        portletModel.setCssClassWrapper(GetterUtil.getString((String)portletElement.elementText("css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean((String)portletElement.elementText("add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
        portletModel.setSystem(GetterUtil.getBoolean((String)portletElement.elementText("system"), (boolean)portletModel.isSystem()));
        portletModel.setActive(GetterUtil.getBoolean((String)portletElement.elementText("active"), (boolean)portletModel.isActive()));
        portletModel.setInclude(GetterUtil.getBoolean((String)portletElement.elementText("include"), (boolean)portletModel.isInclude()));
        if (Validator.isNull((String)servletContextName)) {
            portletModel.setReady(true);
        }
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        Map roleMappersMap = portletModel.getRoleMappers();
        roleMappersMap.putAll(roleMappers);
        portletModel.linkRoles();
    }

    protected Set<String> readLiferayPortletXML(String servletContextName, ServletContext servletContext, String xml, Map<String, Portlet> portletsMap, Map<String, String> portletIdsByStrutsPath) throws Exception {
        HashSet<String> liferayPortletIds = new HashSet<String>();
        if (xml == null) {
            return liferayPortletIds;
        }
        Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this.getPortletApp(servletContextName);
        HashMap<String, String> roleMappers = new HashMap<String, String>();
        for (Element roleMapperElement : rootElement.elements("role-mapper")) {
            String roleName = roleMapperElement.elementText("role-name");
            String roleLink = roleMapperElement.elementText("role-link");
            roleMappers.put(roleName, roleLink);
        }
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Element customUserAttributeElement : rootElement.elements("custom-user-attribute")) {
            String customClass = customUserAttributeElement.elementText("custom-class");
            for (Element nameElement : customUserAttributeElement.elements("name")) {
                String name = nameElement.getText();
                customUserAttributes.put(name, customClass);
            }
        }
        for (Element portletElement : rootElement.elements("portlet")) {
            this.readLiferayPortletXML(servletContextName, servletContext, liferayPortletIds, roleMappers, portletElement, portletsMap, portletIdsByStrutsPath);
        }
        return liferayPortletIds;
    }

    protected void readPortletXML(String servletContextName, PluginPackage pluginPackage, PortletApp portletApp, Element portletElement, Map<String, Portlet> portletsMap, Set<String> validCustomPortletModes) throws PortletIdException {
        Portlet portletModel;
        String portletId;
        String portletName;
        block25: {
            portletId = portletName = portletElement.elementText("portlet-name");
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId.concat("_WAR_").concat(servletContextName);
            }
            if ((portletId = PortalUtil.getJsSafePortletId((String)portletId)).length() > PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH) {
                throw new PortletIdException(StringBundler.concat((String[])new String[]{"Portlet ID ", portletId, " has more than ", String.valueOf(PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH), " characters"}));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading portlet " + portletId));
            }
            if ((portletModel = _portletsMap.get(portletId)) == null) {
                portletModel = new PortletImpl(0L, portletId);
            }
            portletModel.setPluginPackage(pluginPackage);
            portletModel.setPortletApp(portletApp);
            portletModel.setPortletName(portletName);
            portletModel.setDisplayName(GetterUtil.getString((String)portletElement.elementText("display-name"), (String)portletModel.getDisplayName()));
            portletModel.setPortletClass(GetterUtil.getString((String)portletElement.elementText("portlet-class")));
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : portletElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            portletModel.setInitParams(initParams);
            Element expirationCacheElement = portletElement.element("expiration-cache");
            if (expirationCacheElement != null) {
                portletModel.setExpCache(Integer.valueOf(GetterUtil.getInteger((String)expirationCacheElement.getText())));
            }
            HashMap portletModes = new HashMap();
            HashMap windowStates = new HashMap();
            for (Object supportsElement : portletElement.elements("supports")) {
                String mimeType = supportsElement.elementText("mime-type");
                HashSet<String> mimeTypePortletModes = new HashSet<String>();
                mimeTypePortletModes.add(StringUtil.toLowerCase((String)PortletMode.VIEW.toString()));
                for (Element portletModeElement : supportsElement.elements("portlet-mode")) {
                    String portletMode = StringUtil.toLowerCase((String)portletModeElement.getTextTrim());
                    if (this._isCustomPortletMode(portletMode) && !validCustomPortletModes.contains(portletMode)) continue;
                    mimeTypePortletModes.add(portletMode);
                }
                portletModes.put(mimeType, mimeTypePortletModes);
                HashSet<String> mimeTypeWindowStates = new HashSet<String>();
                mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.NORMAL.toString()));
                List windowStateElements = supportsElement.elements("window-state");
                if (windowStateElements.isEmpty()) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.MAXIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.MINIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)LiferayWindowState.EXCLUSIVE.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)LiferayWindowState.POP_UP.toString()));
                }
                for (Element windowStateElement : windowStateElements) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)windowStateElement.getTextTrim()));
                }
                windowStates.put(mimeType, mimeTypeWindowStates);
            }
            portletModel.setPortletModes(portletModes);
            portletModel.setWindowStates(windowStates);
            HashSet<String> supportedLocales = new HashSet<String>();
            for (Element supportedLocaleElement : portletElement.elements("supported-locale")) {
                String supportedLocale = supportedLocaleElement.getText();
                supportedLocales.add(supportedLocale);
            }
            portletModel.setSupportedLocales(supportedLocales);
            portletModel.setResourceBundle(portletElement.elementText("resource-bundle"));
            Element portletInfoElement = portletElement.element("portlet-info");
            String portletInfoTitle = null;
            String portletInfoShortTitle = null;
            String portletInfoKeyWords = null;
            String portletInfoDescription = null;
            if (portletInfoElement != null) {
                portletInfoTitle = portletInfoElement.elementText("title");
                portletInfoShortTitle = portletInfoElement.elementText("short-title");
                portletInfoKeyWords = portletInfoElement.elementText("keywords");
            }
            PortletInfo portletInfo = new PortletInfo(portletInfoTitle, portletInfoShortTitle, portletInfoKeyWords, portletInfoDescription);
            portletModel.setPortletInfo(portletInfo);
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            String defaultPreferences = null;
            String preferencesValidator = null;
            if (portletPreferencesElement != null) {
                Element preferencesValidatorElement = portletPreferencesElement.element("preferences-validator");
                if (preferencesValidatorElement != null) {
                    preferencesValidator = preferencesValidatorElement.getText();
                    portletPreferencesElement.remove(preferencesValidatorElement);
                }
                defaultPreferences = portletPreferencesElement.asXML();
            }
            portletModel.setDefaultPreferences(defaultPreferences);
            portletModel.setPreferencesValidator(preferencesValidator);
            if (!portletApp.isWARFile() && Validator.isNotNull((String)preferencesValidator) && PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                try {
                    PreferencesValidator preferencesValidatorObj = PortalUtil.getPreferencesValidator((Portlet)portletModel);
                    preferencesValidatorObj.validate(PortletPreferencesFactoryUtil.fromDefaultXML((String)defaultPreferences));
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block25;
                    _log.warn((Object)("Portlet with the name " + portletId + " does not have valid default preferences"));
                }
            }
        }
        HashSet<String> unlinkedRoles = new HashSet<String>();
        for (Object roleElement : portletElement.elements("security-role-ref")) {
            unlinkedRoles.add(roleElement.elementText("role-name"));
        }
        portletModel.setUnlinkedRoles(unlinkedRoles);
        HashSet<QName> processingEvents = new HashSet<QName>();
        for (Object supportedProcessingEventElement : portletElement.elements("supported-processing-event")) {
            Element qNameElement = supportedProcessingEventElement.element("qname");
            Element nameElement = supportedProcessingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            processingEvents.add(qName);
            Set eventDefinitions = portletApp.getEventDefinitions();
            for (EventDefinition eventDefinition : eventDefinitions) {
                Set qNames = eventDefinition.getQNames();
                if (!qNames.contains(qName)) continue;
                processingEvents.addAll(qNames);
            }
        }
        portletModel.setProcessingEvents(processingEvents);
        HashSet<QName> publishingEvents = new HashSet<QName>();
        for (Object supportedPublishingEventElement : portletElement.elements("supported-publishing-event")) {
            Element qNameElement = supportedPublishingEventElement.element("qname");
            Element nameElement = supportedPublishingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            publishingEvents.add(qName);
        }
        portletModel.setPublishingEvents(publishingEvents);
        HashSet<PublicRenderParameter> publicRenderParameters = new HashSet<PublicRenderParameter>();
        for (Element supportedPublicRenderParameter : portletElement.elements("supported-public-render-parameter")) {
            String identifier = supportedPublicRenderParameter.getTextTrim();
            PublicRenderParameter publicRenderParameter = portletApp.getPublicRenderParameter(identifier);
            if (publicRenderParameter == null) {
                _log.error((Object)("Supported public render parameter references unknown identifier " + identifier));
                continue;
            }
            publicRenderParameters.add(publicRenderParameter);
        }
        portletModel.setPublicRenderParameters(publicRenderParameters);
        Map containerRuntimeOptions = portletApp.getContainerRuntimeOptions();
        String containerRuntimeOptionPrefix = LiferayPortletConfig.class.getName();
        containerRuntimeOptionPrefix = containerRuntimeOptionPrefix.concat(portletName);
        for (Element containerRuntimeOptionElement : portletElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            containerRuntimeOptions.put(containerRuntimeOptionPrefix.concat(name), values.toArray(new String[values.size()]));
        }
        portletsMap.put(portletId, portletModel);
    }

    protected Map<String, Portlet> readPortletXML(String servletContextName, ServletContext servletContext, String xml, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        String filterName;
        QName qName;
        HashMap<String, Portlet> portletsMap = new HashMap<String, Portlet>();
        if (xml == null) {
            return portletsMap;
        }
        Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)PropsValues.PORTLET_XML_VALIDATE);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this.getPortletApp(servletContextName);
        portletApp.addServletURLPatterns(servletURLPatterns);
        portletApp.setServletContext(servletContext);
        Set userAttributes = portletApp.getUserAttributes();
        for (Object userAttributeElement : rootElement.elements("user-attribute")) {
            String name = userAttributeElement.elementText("name");
            userAttributes.add(name);
        }
        String defaultNamespace = rootElement.elementText("default-namespace");
        if (Validator.isNotNull((String)defaultNamespace)) {
            portletApp.setDefaultNamespace(defaultNamespace);
        }
        for (Element eventDefinitionElement : rootElement.elements("event-definition")) {
            Element qNameElement = eventDefinitionElement.element("qname");
            Element nameElement = eventDefinitionElement.element("name");
            String valueType = eventDefinitionElement.elementText("value-type");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            EventDefinitionImpl eventDefinition = new EventDefinitionImpl(qName, valueType, portletApp);
            List aliases = eventDefinitionElement.elements("alias");
            for (Element alias : aliases) {
                qName = PortletQNameUtil.getQName((Element)alias, null, (String)portletApp.getDefaultNamespace());
                eventDefinition.addAliasQName(qName);
            }
            portletApp.addEventDefinition((EventDefinition)eventDefinition);
        }
        for (Element publicRenderParameterElement : rootElement.elements("public-render-parameter")) {
            String identifier = publicRenderParameterElement.elementText("identifier");
            Element qNameElement = publicRenderParameterElement.element("qname");
            Element nameElement = publicRenderParameterElement.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName, portletApp);
            portletApp.addPublicRenderParameter((PublicRenderParameter)publicRenderParameter);
        }
        for (Element containerRuntimeOptionElement : rootElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            Map containerRuntimeOptions = portletApp.getContainerRuntimeOptions();
            containerRuntimeOptions.put(name, values.toArray(new String[values.size()]));
            if (!name.equals("com.liferay.portal.portalContext") || values.isEmpty() || !GetterUtil.getBoolean((String)((String)values.get(0)))) continue;
            portletApp.setWARFile(false);
        }
        HashSet<String> validCustomPortletModes = new HashSet<String>();
        for (Element customPortletModeElement : rootElement.elements("custom-portlet-mode")) {
            String portletMode = StringUtil.toLowerCase((String)customPortletModeElement.elementTextTrim("portlet-mode"));
            boolean portalManaged = Boolean.valueOf(customPortletModeElement.elementText("portal-managed"));
            if (this._isCustomPortletMode(portletMode) && portalManaged) continue;
            validCustomPortletModes.add(portletMode);
        }
        for (Element portletElement : rootElement.elements("portlet")) {
            this.readPortletXML(servletContextName, pluginPackage, portletApp, portletElement, portletsMap, validCustomPortletModes);
        }
        for (Element filterElement : rootElement.elements("filter")) {
            Object lifecycleElement2;
            filterName = filterElement.elementText("filter-name");
            String filterClass = filterElement.elementText("filter-class");
            LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
            for (Object lifecycleElement2 : filterElement.elements("lifecycle")) {
                lifecycles.add(lifecycleElement2.getText());
            }
            HashMap<String, String> initParams = new HashMap<String, String>();
            lifecycleElement2 = filterElement.elements("init-param").iterator();
            while (lifecycleElement2.hasNext()) {
                Element initParamElement = (Element)lifecycleElement2.next();
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            PortletFilterImpl portletFilter = new PortletFilterImpl(filterName, filterClass, lifecycles, initParams, portletApp);
            portletApp.addPortletFilter((PortletFilter)portletFilter);
        }
        for (Element filterMappingElement : rootElement.elements("filter-mapping")) {
            filterName = filterMappingElement.elementText("filter-name");
            PortletFilter portletFilter = portletApp.getPortletFilter(filterName);
            if (portletFilter == null) {
                _log.error((Object)("Filter mapping references unknown filter name " + filterName));
                continue;
            }
            for (Element portletNameElement : filterMappingElement.elements("portlet-name")) {
                String portletName = portletNameElement.getTextTrim();
                List<Portlet> portletModels = this.getPortletsByPortletName(portletName, servletContextName, portletsMap);
                if (portletModels.isEmpty()) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Filter mapping with filter name ", filterName, " references unknown portlet name ", portletName}));
                }
                for (Portlet portletModel : portletModels) {
                    Map portletFiltersMap = portletModel.getPortletFilters();
                    portletFiltersMap.put(filterName, portletFilter);
                }
            }
        }
        for (Element listenerElement : rootElement.elements("listener")) {
            String listenerClass = listenerElement.elementText("listener-class");
            PortletURLListenerImpl portletURLListener = new PortletURLListenerImpl(listenerClass, portletApp);
            portletApp.addPortletURLListener((PortletURLListener)portletURLListener);
        }
        return portletsMap;
    }

    protected Set<String> readWebXML(String xml) throws Exception {
        LinkedHashSet<String> servletURLPatterns = new LinkedHashSet<String>();
        if (xml == null) {
            return servletURLPatterns;
        }
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element servletMappingElement : rootElement.elements("servlet-mapping")) {
            String urlPattern = servletMappingElement.elementText("url-pattern");
            servletURLPatterns.add(urlPattern);
        }
        return servletURLPatterns;
    }

    protected void setSpriteImages(ServletContext servletContext, PortletApp portletApp, String resourcePath) throws Exception {
        String rootPath;
        String spritePropertiesFileName;
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null || resourcePaths.isEmpty()) {
            return;
        }
        ArrayList<URL> imageURLs = new ArrayList<URL>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this.setSpriteImages(servletContext, portletApp, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            URL imageURL = servletContext.getResource(curResourcePath);
            if (imageURL != null) {
                imageURLs.add(imageURL);
                continue;
            }
            _log.error((Object)("Resource URL for " + curResourcePath + " is null"));
        }
        String spriteRootDirName = PropsValues.SPRITE_ROOT_DIR;
        String spriteFileName = resourcePath.concat(PropsValues.SPRITE_FILE_NAME);
        Properties spriteProperties = SpriteProcessorUtil.generate((ServletContext)servletContext, imageURLs, (String)spriteRootDirName, (String)spriteFileName, (String)(spritePropertiesFileName = resourcePath.concat(PropsValues.SPRITE_PROPERTIES_FILE_NAME)), (String)(rootPath = ServletContextUtil.getRootPath((ServletContext)servletContext)), (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        String contextPath = servletContext.getContextPath();
        spriteFileName = contextPath.concat("/sprite").concat(spriteFileName);
        portletApp.setSpriteImages(spriteFileName, spriteProperties);
    }

    protected Portlet updatePortlet(long companyId, String portletId, String roles) {
        Portlet existingPortlet = this.portletPersistence.fetchByC_P(companyId, portletId);
        boolean active = true;
        if (existingPortlet != null) {
            active = existingPortlet.isActive();
        }
        return this.updatePortlet(companyId, portletId, roles, active);
    }

    private boolean _isCustomPortletMode(String portletModeName) {
        return PortalUtil.isCustomPortletMode((PortletMode)new PortletMode(portletModeName));
    }

    private void _readWebXML(String xml, String servletContextName) throws Exception {
        HashMap<String, String> localeEncodings = new HashMap<String, String>();
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element localeEncodingMappingListElement : rootElement.elements("locale-encoding-mapping-list")) {
            for (Element localeEncodingMappingElement : localeEncodingMappingListElement.elements("locale-encoding-mapping")) {
                String locale = GetterUtil.getString((String)localeEncodingMappingElement.elementText("locale"));
                String encoding = GetterUtil.getString((String)localeEncodingMappingElement.elementText("encoding"));
                localeEncodings.put(locale, encoding);
            }
        }
        ExtraPortletAppConfig extraPortletAppConfig = new ExtraPortletAppConfig(localeEncodings);
        ExtraPortletAppConfigRegistry.registerExtraPortletAppConfig(servletContextName, extraPortletAppConfig);
    }

    static {
        _portletsMap = new ConcurrentHashMap<String, Portlet>();
        _portletsMaps = new ConcurrentHashMap<Long, Map<String, Portlet>>();
        _propertiesConfigurations = new ConcurrentHashMap<ClassLoader, Configuration>();
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLMapper, String[]> {
        private FriendlyURLMapperServiceTrackerCustomizer() {
        }

        public String[] addingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            Object propertyValue = serviceReference.getProperty("javax.portlet.name");
            if (propertyValue == null) {
                return null;
            }
            if (propertyValue instanceof String) {
                Object[] newFriendlyURLMapperRootPortletIds;
                Object[] friendlyURLMapperRootPortletIds;
                String portletId = (String)propertyValue;
                String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                rootPortletId = JS.getSafeName((String)rootPortletId);
                do {
                    friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                    newFriendlyURLMapperRootPortletIds = (String[])ArrayUtil.append((Object[])friendlyURLMapperRootPortletIds, (Object)rootPortletId);
                    Arrays.sort(newFriendlyURLMapperRootPortletIds);
                } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
                return new String[]{rootPortletId};
            }
            if (propertyValue instanceof String[]) {
                Object[] newFriendlyURLMapperRootPortletIds;
                Object[] friendlyURLMapperRootPortletIds;
                String[] portletIds = (String[])propertyValue;
                Object[] rootPortletIds = new String[portletIds.length];
                for (int i = 0; i < portletIds.length; ++i) {
                    String rootPortletId = PortletIdCodec.decodePortletName((String)portletIds[i]);
                    rootPortletIds[i] = JS.getSafeName((String)rootPortletId);
                }
                do {
                    friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                    newFriendlyURLMapperRootPortletIds = (String[])ArrayUtil.append((Object[])friendlyURLMapperRootPortletIds, (Object[])rootPortletIds);
                    Arrays.sort(newFriendlyURLMapperRootPortletIds);
                } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
                return rootPortletIds;
            }
            return null;
        }

        public void modifiedService(ServiceReference<FriendlyURLMapper> serviceReference, String[] rootPortletIds) {
            this.removedService(serviceReference, rootPortletIds);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<FriendlyURLMapper> serviceReference, String[] rootPortletIds) {
            String[] newFriendlyURLMapperRootPortletIds;
            String[] friendlyURLMapperRootPortletIds;
            do {
                newFriendlyURLMapperRootPortletIds = friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                for (String rootPortletId : rootPortletIds) {
                    newFriendlyURLMapperRootPortletIds = ArrayUtil.remove((String[])newFriendlyURLMapperRootPortletIds, (String)rootPortletId);
                }
            } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
        }
    }
}

