/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AdvisedSupportProxy;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.MethodInterceptorsBag;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManager;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.util.ClassUtils;

public class ServiceBeanAopProxy
implements AdvisedSupportProxy,
AopProxy,
InvocationHandler {
    private static final Log _log = LogFactoryUtil.getLog(ServiceBeanAopProxy.class);
    private static final PACL _pacl = new NoPACL();
    private final AdvisedSupport _advisedSupport;
    private final AdvisorChainFactory _advisorChainFactory;
    private final List<MethodInterceptor> _classLevelMethodInterceptors;
    private final List<MethodInterceptor> _fullMethodInterceptors;
    private final boolean _mergeSpringMethodInterceptors;
    private final ServiceBeanAopCacheManager _serviceBeanAopCacheManager;

    public static AdvisedSupport getAdvisedSupport(Object proxy) throws Exception {
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)proxy);
        if (invocationHandler instanceof AdvisedSupportProxy) {
            AdvisedSupportProxy advisableSupportProxy = (AdvisedSupportProxy)((Object)invocationHandler);
            return advisableSupportProxy.getAdvisedSupport();
        }
        return null;
    }

    public ServiceBeanAopProxy(AdvisedSupport advisedSupport, MethodInterceptor methodInterceptor, ServiceBeanAopCacheManager serviceBeanAopCacheManager) {
        this._advisedSupport = advisedSupport;
        this._advisorChainFactory = this._advisedSupport.getAdvisorChainFactory();
        Object[] proxyInterfaces = this._advisedSupport.getProxiedInterfaces();
        this._mergeSpringMethodInterceptors = !ArrayUtil.contains((Object[])proxyInterfaces, SpringProxy.class);
        ArrayList<MethodInterceptor> classLevelMethodInterceptors = new ArrayList<MethodInterceptor>();
        ArrayList<MethodInterceptor> fullMethodInterceptors = new ArrayList<MethodInterceptor>();
        while (true) {
            if (!(methodInterceptor instanceof ChainableMethodAdvice)) break;
            ChainableMethodAdvice chainableMethodAdvice = (ChainableMethodAdvice)methodInterceptor;
            chainableMethodAdvice.setServiceBeanAopCacheManager(serviceBeanAopCacheManager);
            if (methodInterceptor instanceof AnnotationChainableMethodAdvice) {
                AnnotationChainableMethodAdvice annotationChainableMethodAdvice = (AnnotationChainableMethodAdvice)methodInterceptor;
                Class<Annotation> annotationClass = annotationChainableMethodAdvice.getAnnotationClass();
                Target target = annotationClass.getAnnotation(Target.class);
                if (target == null) {
                    classLevelMethodInterceptors.add(methodInterceptor);
                } else {
                    for (ElementType elementType : target.value()) {
                        if (elementType != ElementType.TYPE) continue;
                        classLevelMethodInterceptors.add(methodInterceptor);
                        break;
                    }
                }
            } else {
                classLevelMethodInterceptors.add(methodInterceptor);
            }
            fullMethodInterceptors.add(methodInterceptor);
            methodInterceptor = chainableMethodAdvice.nextMethodInterceptor;
        }
        classLevelMethodInterceptors.add(methodInterceptor);
        fullMethodInterceptors.add(methodInterceptor);
        classLevelMethodInterceptors.trimToSize();
        this._classLevelMethodInterceptors = classLevelMethodInterceptors;
        this._fullMethodInterceptors = fullMethodInterceptors;
        this._serviceBeanAopCacheManager = serviceBeanAopCacheManager;
    }

    @Override
    public AdvisedSupport getAdvisedSupport() {
        return this._advisedSupport;
    }

    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    public Object getProxy(ClassLoader classLoader) {
        Class[] proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces((AdvisedSupport)this._advisedSupport);
        InvocationHandler invocationHandler = _pacl.getInvocationHandler(this, this._advisedSupport);
        return ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])proxiedInterfaces, (InvocationHandler)invocationHandler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        TargetSource targetSource = this._advisedSupport.getTargetSource();
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = new ServiceBeanMethodInvocation(targetSource.getTarget(), method, arguments);
        this._setMethodInterceptors(serviceBeanMethodInvocation);
        return serviceBeanMethodInvocation.proceed();
    }

    private List<MethodInterceptor> _getMethodInterceptors(ServiceBeanMethodInvocation serviceBeanMethodInvocation) {
        ArrayList<MethodInterceptor> methodInterceptors = new ArrayList<MethodInterceptor>(this._fullMethodInterceptors);
        if (!this._mergeSpringMethodInterceptors) {
            return methodInterceptors;
        }
        List list = this._advisorChainFactory.getInterceptorsAndDynamicInterceptionAdvice((Advised)this._advisedSupport, serviceBeanMethodInvocation.getMethod(), serviceBeanMethodInvocation.getTargetClass());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof MethodInterceptor) continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Skipping unsupported interceptor type " + obj.getClass()));
            }
            itr.remove();
        }
        if (list.isEmpty()) {
            return methodInterceptors;
        }
        for (Object object : list) {
            methodInterceptors.add((MethodInterceptor)object);
        }
        return methodInterceptors;
    }

    private void _setMethodInterceptors(ServiceBeanMethodInvocation serviceBeanMethodInvocation) {
        MethodInterceptorsBag methodInterceptorsBag = this._serviceBeanAopCacheManager.getMethodInterceptorsBag(serviceBeanMethodInvocation);
        if (methodInterceptorsBag == null) {
            List<MethodInterceptor> methodInterceptors = this._getMethodInterceptors(serviceBeanMethodInvocation);
            methodInterceptorsBag = new MethodInterceptorsBag(this._classLevelMethodInterceptors, methodInterceptors);
            this._serviceBeanAopCacheManager.putMethodInterceptorsBag(serviceBeanMethodInvocation, methodInterceptorsBag);
        }
        serviceBeanMethodInvocation.setMethodInterceptors(methodInterceptorsBag.getMergedMethodInterceptors());
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public InvocationHandler getInvocationHandler(InvocationHandler invocationHandler, AdvisedSupport advisedSupport) {
            return invocationHandler;
        }
    }

    public static interface PACL {
        public InvocationHandler getInvocationHandler(InvocationHandler var1, AdvisedSupport var2);
    }
}

