/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.TemplateResourceParser;
import com.liferay.portal.template.URLResourceParser;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

@OSGiBeanProperties(property={"lang.type=ftl", "lang.type=vm"}, service={TemplateResourceParser.class})
public class ThemeResourceParser
extends URLResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(ThemeResourceParser.class);

    @Override
    public URL getURL(String templateId) throws IOException {
        String themesPath;
        String servletContextName;
        ThemeLoader themeLoader;
        int pos = templateId.indexOf("_THEME_LOADER_CONTEXT_");
        if (pos == -1) {
            return null;
        }
        if (templateId.endsWith(".vm")) {
            StringBundler sb = new StringBundler(4);
            sb.append("Velocity is no longer supported for themes. Please ");
            sb.append("update template ");
            sb.append(templateId);
            sb.append(" to use FreeMarker.");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)sb.toString());
            }
        }
        if ((themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName = templateId.substring(0, pos))) == null) {
            _log.error((Object)StringBundler.concat((String[])new String[]{templateId, " is not valid because ", servletContextName, " does not map to a theme loader"}));
            return null;
        }
        String templateName = templateId.substring(pos + "_THEME_LOADER_CONTEXT_".length());
        if (templateName.startsWith(themesPath = themeLoader.getThemesPath())) {
            templateId = templateName.substring(themesPath.length());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{templateId, " is associated with the theme loader ", servletContextName, " ", String.valueOf(themeLoader)}));
        }
        File fileStorage = themeLoader.getFileStorage();
        File file = new File(fileStorage, templateId);
        URI uri = file.toURI();
        return uri.toURL();
    }
}

