/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.UploadServletRequestImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class UploadPortletRequestImpl
extends HttpServletRequestWrapper
implements UploadPortletRequest {
    private final String _namespace;
    private final PortletRequest _portletRequest;
    private final UploadServletRequest _uploadServletRequest;

    public UploadPortletRequestImpl(UploadServletRequest uploadServletRequest, PortletRequest portletRequest, String namespace) {
        super((HttpServletRequest)uploadServletRequest);
        this._uploadServletRequest = uploadServletRequest;
        this._portletRequest = portletRequest;
        this._namespace = namespace;
    }

    public void cleanUp() {
        this._uploadServletRequest.cleanUp();
    }

    public String getContentType(String name) {
        File file;
        String contentType = this._uploadServletRequest.getContentType(this._namespace.concat(name));
        if (contentType == null) {
            contentType = this._uploadServletRequest.getContentType(name);
        }
        if ((Validator.isNull((String)contentType) || contentType.equals("application/octet-stream")) && (file = this.getFile(name)) != null) {
            contentType = MimeTypesUtil.getContentType((File)file);
        }
        return contentType;
    }

    public File getFile(String name) {
        return this.getFile(name, false);
    }

    public File getFile(String name, boolean forceCreate) {
        File file = this._uploadServletRequest.getFile(this._namespace.concat(name), forceCreate);
        if (file == null) {
            file = this._uploadServletRequest.getFile(name, forceCreate);
        }
        return file;
    }

    public InputStream getFileAsStream(String name) throws IOException {
        return this.getFileAsStream(name, true);
    }

    public InputStream getFileAsStream(String name, boolean deleteOnClose) throws IOException {
        InputStream inputStream = this._uploadServletRequest.getFileAsStream(this._namespace.concat(name), deleteOnClose);
        if (inputStream == null) {
            inputStream = this._uploadServletRequest.getFileAsStream(name, deleteOnClose);
        }
        return inputStream;
    }

    public String getFileName(String name) {
        String fileName = this._uploadServletRequest.getFileName(this._namespace.concat(name));
        if (fileName == null) {
            fileName = this._uploadServletRequest.getFileName(name);
        }
        return fileName;
    }

    public String[] getFileNames(String name) {
        String[] fileNames = this._uploadServletRequest.getFileNames(this._namespace.concat(name));
        if (fileNames == null) {
            fileNames = this._uploadServletRequest.getFileNames(name);
        }
        return fileNames;
    }

    public File[] getFiles(String name) {
        File[] files = this._uploadServletRequest.getFiles(this._namespace.concat(name));
        if (files == null) {
            files = this._uploadServletRequest.getFiles(name);
        }
        return files;
    }

    public InputStream[] getFilesAsStream(String name) throws IOException {
        return this.getFilesAsStream(name, true);
    }

    public InputStream[] getFilesAsStream(String name, boolean deleteOnClose) throws IOException {
        InputStream[] inputStreams = this._uploadServletRequest.getFilesAsStream(this._namespace.concat(name), deleteOnClose);
        if (inputStreams == null) {
            inputStreams = this._uploadServletRequest.getFilesAsStream(name, deleteOnClose);
        }
        return inputStreams;
    }

    public String getFullFileName(String name) {
        String fullFileName = this._uploadServletRequest.getFullFileName(this._namespace.concat(name));
        if (fullFileName == null) {
            fullFileName = this._uploadServletRequest.getFullFileName(name);
        }
        return fullFileName;
    }

    public Map<String, FileItem[]> getMultipartParameterMap() {
        if (!(this._uploadServletRequest instanceof UploadServletRequestImpl)) {
            return Collections.emptyMap();
        }
        HashMap<String, FileItem[]> map = new HashMap<String, FileItem[]>();
        UploadServletRequestImpl uploadServletRequestImpl = (UploadServletRequestImpl)this._uploadServletRequest;
        Map<String, FileItem[]> multipartParameterMap = uploadServletRequestImpl.getMultipartParameterMap();
        for (Map.Entry<String, FileItem[]> entry : multipartParameterMap.entrySet()) {
            String name = entry.getKey();
            FileItem[] fileItems = entry.getValue();
            if (name.startsWith(this._namespace)) {
                map.put(name.substring(this._namespace.length()), fileItems);
                continue;
            }
            map.put(name, fileItems);
        }
        return map;
    }

    public String getParameter(String name) {
        String parameter = this._uploadServletRequest.getParameter(this._namespace.concat(name));
        if (parameter == null) {
            parameter = this._uploadServletRequest.getParameter(name);
        }
        return parameter;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Enumeration enu = this._uploadServletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (name.startsWith(this._namespace)) {
                parameterNames.add(name.substring(this._namespace.length()));
                continue;
            }
            parameterNames.add(name);
        }
        return Collections.enumeration(parameterNames);
    }

    public String[] getParameterValues(String name) {
        String[] parameterValues = this._uploadServletRequest.getParameterValues(this._namespace.concat(name));
        if (parameterValues == null) {
            parameterValues = this._uploadServletRequest.getParameterValues(name);
        }
        return parameterValues;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public Map<String, List<String>> getRegularParameterMap() {
        if (!(this._uploadServletRequest instanceof UploadServletRequestImpl)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        UploadServletRequestImpl uploadServletRequestImpl = (UploadServletRequestImpl)this._uploadServletRequest;
        Map<String, List<String>> regularParameterMap = uploadServletRequestImpl.getRegularParameterMap();
        for (Map.Entry<String, List<String>> entry : regularParameterMap.entrySet()) {
            String name = entry.getKey();
            List<String> parameters = entry.getValue();
            if (name.startsWith(this._namespace)) {
                map.put(name.substring(this._namespace.length()), parameters);
                continue;
            }
            map.put(name, parameters);
        }
        return map;
    }

    public Long getSize(String name) {
        Long size = this._uploadServletRequest.getSize(this._namespace.concat(name));
        if (size == null) {
            size = this._uploadServletRequest.getSize(name);
        }
        if (size == null) {
            return 0L;
        }
        return size;
    }

    public Boolean isFormField(String name) {
        Boolean formField = this._uploadServletRequest.isFormField(this._namespace.concat(name));
        if (formField == null) {
            formField = this._uploadServletRequest.isFormField(name);
        }
        if (formField == null) {
            return true;
        }
        return (boolean)formField;
    }
}

