/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.PortletContextFactory;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portlet.PortletContextImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletContextFactoryImpl
implements PortletContextFactory {
    private final Map<String, Map<String, PortletContext>> _pool = new ConcurrentHashMap<String, Map<String, PortletContext>>();

    public PortletContext create(Portlet portlet, ServletContext servletContext) {
        Map<String, PortletContext> portletContexts = this._pool.get(portlet.getRootPortletId());
        if (portletContexts == null) {
            portletContexts = new ConcurrentHashMap<String, PortletContext>();
            this._pool.put(portlet.getRootPortletId(), portletContexts);
        }
        Object portletContext = null;
        if (portlet.isUndeployedPortlet()) {
            portletContexts.remove(portlet.getPortletId());
        } else {
            portletContext = portletContexts.get(portlet.getPortletId());
        }
        if (portletContext != null) {
            return DoPrivilegedUtil.wrap(portletContext);
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (!portlet.isUndeployedPortlet() && portletApp.isWARFile()) {
            servletContext = portletApp.getServletContext();
        }
        portletContext = new PortletContextImpl(portlet, servletContext);
        portletContexts.put(portlet.getPortletId(), (PortletContext)portletContext);
        return DoPrivilegedUtil.wrap(portletContext);
    }

    public PortletContext createUntrackedInstance(Portlet portlet, ServletContext servletContext) {
        PortletContextImpl portletContext = new PortletContextImpl(portlet, servletContext);
        return (PortletContext)DoPrivilegedUtil.wrap(portletContext);
    }

    public void destroy(Portlet portlet) {
        this._pool.remove(portlet.getRootPortletId());
    }
}

