/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.TransferHeadersHelperUtil;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.struts.StrutsActionPortletURL;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowStateException;
import javax.portlet.filter.PortletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements LiferayPortletResponse {
    protected String portletName;
    protected PortletRequestImpl portletRequestImpl;
    protected HttpServletResponse response;
    private static final Log _log = LogFactoryUtil.getLog(PortletResponseImpl.class);
    private long _companyId;
    private final Map<String, Constructor<? extends PortletURLImpl>> _constructors = new ConcurrentHashMap<String, Constructor<? extends PortletURLImpl>>();
    private Document _document;
    private final Map<String, Object> _headers = new LinkedHashMap<String, Object>();
    private final Map<String, List<Element>> _markupHeadElements = new LinkedHashMap<String, List<Element>>();
    private String _namespace;
    private long _plid;
    private Portlet _portlet;
    private PortletPreferences _portletSetup;
    private URLEncoder _urlEncoder;
    private boolean _wsrp;

    public static PortletResponseImpl getPortletResponseImpl(PortletResponse portletResponse) {
        while (!(portletResponse instanceof PortletResponseImpl)) {
            if (portletResponse instanceof PortletResponseWrapper) {
                PortletResponseWrapper portletResponseWrapper = (PortletResponseWrapper)portletResponse;
                portletResponse = portletResponseWrapper.getResponse();
                continue;
            }
            throw new RuntimeException("Unable to unwrap the portlet response from " + portletResponse.getClass());
        }
        return (PortletResponseImpl)portletResponse;
    }

    public void addDateHeader(String name, long date) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        Object[] values = (Long[])this._headers.get(name);
        if (values == null) {
            this.setDateHeader(name, date);
        } else {
            values = (Long[])ArrayUtil.append((Object[])values, (Object)date);
            this._headers.put(name, values);
        }
    }

    public void addHeader(String name, String value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        Object[] values = (String[])this._headers.get(name);
        if (values == null) {
            this.setHeader(name, value);
        } else {
            values = (String[])ArrayUtil.append((Object[])values, (Object)value);
            this._headers.put(name, values);
        }
    }

    public void addIntHeader(String name, int value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        Object[] values = (Integer[])this._headers.get(name);
        if (values == null) {
            this.setIntHeader(name, value);
        } else {
            values = (Integer[])ArrayUtil.append((Object[])values, (Object)value);
            this._headers.put(name, values);
        }
    }

    public void addProperty(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException();
        }
        Object[] cookies = (Cookie[])this._headers.get("cookies");
        if (cookies == null) {
            this._headers.put("cookies", new Cookie[]{cookie});
        } else {
            cookies = (Cookie[])ArrayUtil.append((Object[])cookies, (Object)cookie);
            this._headers.put("cookies", cookies);
        }
    }

    public void addProperty(String key, Element element) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.equalsIgnoreCase((String)key, (String)"javax.portlet.markup.head.element")) {
            List<Element> values;
            if (StringUtil.equalsIgnoreCase((String)element.getNodeName(), (String)"script") && !element.hasChildNodes()) {
                element = (Element)element.cloneNode(true);
                element.appendChild(this._document.createTextNode(" "));
            }
            if ((values = this._markupHeadElements.get(key)) != null) {
                if (element != null) {
                    values.add(element);
                } else {
                    this._markupHeadElements.remove(key);
                }
            } else if (element != null) {
                values = new ArrayList<Element>();
                values.add(element);
                this._markupHeadElements.put(key, values);
            }
        }
    }

    public void addProperty(String key, String value) {
        if (Validator.isNull((String)key)) {
            throw new IllegalArgumentException();
        }
        this.addHeader(key, value);
    }

    public PortletURL createActionURL() {
        return this.createActionURL(this.portletName);
    }

    public LiferayPortletURL createActionURL(String portletName) {
        return this.createLiferayPortletURL(portletName, "ACTION_PHASE");
    }

    public Element createElement(String tagName) throws DOMException {
        if (this._document == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this._document = documentBuilder.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new DOMException(11, pce.getMessage());
            }
        }
        return this._document.createElement(tagName);
    }

    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle) {
        return this.createLiferayPortletURL(plid, portletName, lifecycle, true);
    }

    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle, boolean includeLinkToLayoutUuid) {
        return (LiferayPortletURL)DoPrivilegedUtil.wrap(new LiferayPortletURLPrivilegedAction(plid, portletName, lifecycle, includeLinkToLayoutUuid));
    }

    public LiferayPortletURL createLiferayPortletURL(String lifecycle) {
        return this.createLiferayPortletURL(this.portletName, lifecycle);
    }

    public LiferayPortletURL createLiferayPortletURL(String portletName, String lifecycle) {
        return this.createLiferayPortletURL(this._plid, portletName, lifecycle);
    }

    public PortletURL createRenderURL() {
        return this.createRenderURL(this.portletName);
    }

    public LiferayPortletURL createRenderURL(String portletName) {
        return this.createLiferayPortletURL(portletName, "RENDER_PHASE");
    }

    public ResourceURL createResourceURL() {
        return this.createResourceURL(this.portletName);
    }

    public LiferayPortletURL createResourceURL(String portletName) {
        return this.createLiferayPortletURL(portletName, "RESOURCE_PHASE");
    }

    public String encodeURL(String path) {
        if (path == null || !path.startsWith("#") && !path.startsWith("/") && !path.contains("://")) {
            throw new IllegalArgumentException("URL path must start with a '/' or include '://'");
        }
        if (this._urlEncoder != null) {
            return this._urlEncoder.encodeURL(this.response, path);
        }
        return path;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.portletRequestImpl.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public abstract String getLifecycle();

    public String getNamespace() {
        if (this._wsrp) {
            return "wsrp_rewrite_";
        }
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace((String)this.portletName);
        }
        return this._namespace;
    }

    public long getPlid() {
        return this._plid;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public PortletRequestImpl getPortletRequest() {
        return this.portletRequestImpl;
    }

    public Map<String, String[]> getProperties() {
        LinkedHashMap<String, String[]> properties = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, Object> entry : this._headers.entrySet()) {
            String name = entry.getKey();
            Object[] values = (Object[])entry.getValue();
            String[] valuesString = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesString[i] = values[i].toString();
            }
            properties.put(name, valuesString);
        }
        return properties;
    }

    public URLEncoder getUrlEncoder() {
        return this._urlEncoder;
    }

    public void setDateHeader(String name, long date) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (date <= 0L) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Long[]{date});
        }
    }

    public void setHeader(String name, String value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (Validator.isNull((String)value)) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new String[]{value});
        }
    }

    public void setIntHeader(String name, int value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (value <= 0) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Integer[]{value});
        }
    }

    public void setPlid(long plid) {
        Layout layout;
        this._plid = plid;
        if (this._plid <= 0L && (layout = (Layout)this.portletRequestImpl.getAttribute("LAYOUT")) != null) {
            this._plid = layout.getPlid();
        }
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.setHeader(key, value);
    }

    public void setURLEncoder(URLEncoder urlEncoder) {
        this._urlEncoder = urlEncoder;
    }

    public void transferHeaders(HttpServletResponse response) {
        TransferHeadersHelperUtil.transferHeaders(this._headers, (HttpServletResponse)response);
    }

    public void transferMarkupHeadElements() {
        List<Element> elements = this._markupHeadElements.get("javax.portlet.markup.head.element");
        if (elements == null || elements.isEmpty()) {
            return;
        }
        HttpServletRequest request = this.getHttpServletRequest();
        ArrayList<String> markupHeadElements = (ArrayList<String>)request.getAttribute("javax.portlet.markup.head.element");
        if (markupHeadElements == null) {
            markupHeadElements = new ArrayList<String>();
            request.setAttribute("javax.portlet.markup.head.element", markupHeadElements);
        }
        for (Element element : elements) {
            try {
                UnsyncStringWriter writer = new UnsyncStringWriter();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(element), new StreamResult((Writer)writer));
                markupHeadElements.add(writer.toString());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected LiferayPortletURL doCreateLiferayPortletURL(long plid, String portletName, String lifecycle, boolean includeLinkToLayoutUuid) {
        block23: {
            try {
                Layout layout = (Layout)this.portletRequestImpl.getAttribute("LAYOUT");
                ThemeDisplay themeDisplay = (ThemeDisplay)this.portletRequestImpl.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                if (layout == null && themeDisplay != null) {
                    layout = themeDisplay.getLayout();
                }
                if (this._portletSetup == null) {
                    this._portletSetup = themeDisplay == null ? PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup((Layout)layout, (String)this.portletName) : themeDisplay.getStrictLayoutPortletSetup(layout, this.portletName);
                }
                String linkToLayoutUuid = GetterUtil.getString((String)this._portletSetup.getValue("portletSetupLinkToLayoutUuid", null));
                if (PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render") && !"RENDER_PHASE".equals(lifecycle)) {
                    includeLinkToLayoutUuid = false;
                }
                if (Validator.isNotNull((String)linkToLayoutUuid) && includeLinkToLayoutUuid) {
                    try {
                        Layout linkedLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)linkToLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
                        plid = linkedLayout.getPlid();
                    }
                    catch (PortalException pe) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)pe, (Throwable)pe);
                        }
                    }
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block23;
                _log.warn((Throwable)se);
            }
        }
        if (plid == 0L) {
            plid = this._plid;
        }
        LiferayPortletURL portletURL = null;
        Portlet portlet = this.getPortlet();
        String portletURLClass = portlet.getPortletURLClass();
        String portletId = portlet.getPortletId();
        if (portletId.equals(portletName) && Validator.isNotNull((String)portletURLClass)) {
            if (portletURLClass.equals(StrutsActionPortletURL.class.getName())) {
                portletURL = new StrutsActionPortletURL(this, plid, lifecycle);
            } else {
                try {
                    Constructor<PortletURLImpl> constructor = this._constructors.get(portletURLClass);
                    if (constructor == null) {
                        Class<?> portletURLClassObj = Class.forName(portletURLClass);
                        constructor = portletURLClassObj.getConstructor(PortletResponseImpl.class, Long.TYPE, String.class);
                        this._constructors.put(portletURLClass, constructor);
                    }
                    portletURL = constructor.newInstance(this, plid, lifecycle);
                }
                catch (Exception e) {
                    _log.error((Object)"Unable to create portlet URL", (Throwable)e);
                }
            }
        }
        if (portletURL == null) {
            portletURL = portletName.equals(portlet.getPortletId()) ? PortletURLFactoryUtil.create((PortletRequest)this.portletRequestImpl, (Portlet)portlet, (long)plid, (String)lifecycle) : PortletURLFactoryUtil.create((PortletRequest)this.portletRequestImpl, (String)portletName, (long)plid, (String)lifecycle);
        }
        try {
            if (portlet.hasWindowState(this.portletRequestImpl.getResponseContentType(), this.portletRequestImpl.getWindowState())) {
                portletURL.setWindowState(this.portletRequestImpl.getWindowState());
            }
        }
        catch (WindowStateException wse) {
            _log.error((Object)wse.getMessage());
        }
        try {
            if (portlet.hasPortletMode(this.portletRequestImpl.getResponseContentType(), this.portletRequestImpl.getPortletMode())) {
                portletURL.setPortletMode(this.portletRequestImpl.getPortletMode());
            }
        }
        catch (PortletModeException pme) {
            _log.error((Object)pme.getMessage());
        }
        return portletURL;
    }

    protected void init(PortletRequestImpl portletRequestImpl, HttpServletResponse response) {
        this.portletRequestImpl = portletRequestImpl;
        this.response = response;
        this._portlet = portletRequestImpl.getPortlet();
        this.portletName = this._portlet.getPortletId();
        this._companyId = this._portlet.getCompanyId();
        this._wsrp = ParamUtil.getBoolean((HttpServletRequest)portletRequestImpl.getHttpServletRequest(), (String)"wsrp");
        this.setPlid(portletRequestImpl.getPlid());
    }

    @Deprecated
    protected void init(PortletRequestImpl portletRequestImpl, HttpServletResponse response, String portletName, long companyId, long plid) {
        this.init(portletRequestImpl, response);
    }

    private class LiferayPortletURLPrivilegedAction
    implements PrivilegedAction<LiferayPortletURL> {
        private final boolean _includeLinkToLayoutUuid;
        private final String _lifecycle;
        private long _plid;
        private final String _portletName;

        public LiferayPortletURLPrivilegedAction(long plid, String portletName, String lifecycle, boolean includeLinkToLayoutUuid) {
            this._plid = plid;
            this._portletName = portletName;
            this._lifecycle = lifecycle;
            this._includeLinkToLayoutUuid = includeLinkToLayoutUuid;
        }

        @Override
        public LiferayPortletURL run() {
            return PortletResponseImpl.this.doCreateLiferayPortletURL(this._plid, this._portletName, this._lifecycle, this._includeLinkToLayoutUuid);
        }
    }
}

