/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.portlet.PortletConfigurationLayoutUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portlet.configuration.kernel.util.PortletConfigurationUtil;
import com.liferay.portlet.portletconfiguration.util.ConfigurationActionRequest;
import com.liferay.portlet.portletconfiguration.util.ConfigurationPortletRequest;
import com.liferay.portlet.portletconfiguration.util.ConfigurationRenderRequest;
import com.liferay.portlet.portletconfiguration.util.ConfigurationResourceRequest;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterConfiguration;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterIdentifierComparator;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterIdentifierConfigurationComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static final String ACTION = "_ACTION_";
    public static final String PRESELECTED = "_PRESELECTED_";

    public static PortletPreferences getLayoutPortletSetup(PortletRequest portletRequest, Portlet portlet) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        return PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
    }

    public static void getLayoutPublicRenderParameters(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashSet<String> identifiers = new HashSet<String>();
        TreeSet<PublicRenderParameter> publicRenderParameters = new TreeSet<PublicRenderParameter>(new PublicRenderParameterIdentifierComparator());
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets()) {
            for (PublicRenderParameter publicRenderParameter : portlet.getPublicRenderParameters()) {
                if (identifiers.contains(publicRenderParameter.getIdentifier())) continue;
                identifiers.add(publicRenderParameter.getIdentifier());
                publicRenderParameters.add(publicRenderParameter);
            }
        }
        portletRequest.setAttribute("PUBLIC_RENDER_PARAMETERS", publicRenderParameters);
    }

    public static Portlet getPortlet(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String portletId = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
        Layout layout = PortletConfigurationLayoutUtil.getLayout((ThemeDisplay)themeDisplay);
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)themeDisplay.getScopeGroupId(), (Layout)layout, (String)portletId, (String)"CONFIGURATION")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, "CONFIGURATION"});
        }
        return PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
    }

    public static void getPublicRenderParameterConfigurationList(PortletRequest portletRequest, Portlet portlet) throws Exception {
        PortletPreferences preferences = null;
        if (portletRequest instanceof ConfigurationPortletRequest) {
            preferences = portletRequest.getPreferences();
        } else {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        }
        ArrayList<PublicRenderParameterConfiguration> publicRenderParameterConfigurations = new ArrayList<PublicRenderParameterConfiguration>();
        for (PublicRenderParameter publicRenderParameter : portlet.getPublicRenderParameters()) {
            String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName());
            String mappingKey = PublicRenderParameterConfiguration.getMappingKey(publicRenderParameterName);
            String ignoreKey = PublicRenderParameterConfiguration.getIgnoreKey(publicRenderParameterName);
            String mappingValue = null;
            boolean ignoreValue = false;
            if (SessionErrors.isEmpty((PortletRequest)portletRequest)) {
                mappingValue = preferences.getValue(mappingKey, null);
                ignoreValue = GetterUtil.getBoolean((String)preferences.getValue(ignoreKey, null));
            } else {
                mappingValue = ParamUtil.getString((PortletRequest)portletRequest, (String)mappingKey);
                ignoreValue = GetterUtil.getBoolean((String)ParamUtil.getString((PortletRequest)portletRequest, (String)ignoreKey));
            }
            publicRenderParameterConfigurations.add(new PublicRenderParameterConfiguration(publicRenderParameter, mappingValue, ignoreValue));
        }
        Collections.sort(publicRenderParameterConfigurations, new PublicRenderParameterIdentifierConfigurationComparator());
        portletRequest.setAttribute("PUBLIC_RENDER_PARAMETER_CONFIGURATIONS", publicRenderParameterConfigurations);
    }

    public static String getTitle(Portlet portlet, RenderRequest renderRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ServletContext servletContext = (ServletContext)renderRequest.getAttribute("CTX");
        PortletPreferences portletSetup = null;
        if (renderRequest instanceof ConfigurationPortletRequest) {
            portletSetup = renderRequest.getPreferences();
        } else {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
            portletSetup = ActionUtil.getLayoutPortletSetup((PortletRequest)renderRequest, portlet);
            portletSetup = ActionUtil.getPortletSetup(request, renderRequest.getPreferences(), portletSetup);
        }
        String title = PortletConfigurationUtil.getPortletTitle((PortletPreferences)portletSetup, (String)themeDisplay.getLanguageId());
        if (Validator.isNull((String)title)) {
            title = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)themeDisplay.getLocale());
        }
        return title;
    }

    public static ActionRequest getWrappedActionRequest(ActionRequest actionRequest, PortletPreferences portletPreferences) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        portletPreferences = ActionUtil.getPortletPreferences(request, actionRequest.getPreferences(), portletPreferences);
        return new ConfigurationActionRequest(actionRequest, portletPreferences);
    }

    public static RenderRequest getWrappedRenderRequest(RenderRequest renderRequest, PortletPreferences portletPreferences) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        portletPreferences = ActionUtil.getPortletPreferences(request, renderRequest.getPreferences(), portletPreferences);
        renderRequest = new ConfigurationRenderRequest((RenderRequest)renderRequest, portletPreferences);
        request.setAttribute("javax.portlet.request", renderRequest);
        return renderRequest;
    }

    public static ResourceRequest getWrappedResourceRequest(ResourceRequest resourceRequest, PortletPreferences portletPreferences) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        portletPreferences = ActionUtil.getPortletPreferences(request, resourceRequest.getPreferences(), portletPreferences);
        return new ConfigurationResourceRequest(resourceRequest, portletPreferences);
    }

    protected static PortletPreferences getPortletPreferences(HttpServletRequest request, PortletPreferences portletConfigPortletPreferences, PortletPreferences portletPreferences) throws PortalException {
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        if (Validator.isNull((String)portletResource)) {
            return portletConfigPortletPreferences;
        }
        if (portletPreferences != null) {
            return portletPreferences;
        }
        return PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)request, (String)portletResource);
    }

    protected static PortletPreferences getPortletSetup(HttpServletRequest request, PortletPreferences portletConfigPortletSetup, PortletPreferences portletSetup) throws PortalException {
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        if (Validator.isNull((String)portletResource)) {
            return portletConfigPortletSetup;
        }
        if (portletSetup != null) {
            return portletSetup;
        }
        return PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)request, (String)portletResource);
    }
}

