/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import com.puppycrawl.tools.checkstyle.utils.FilterUtils;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SuppressionFilter
extends AutomaticBean
implements Filter,
ExternalResourceHolder {
    private String file;
    private boolean optional;
    private FilterSet filters = new FilterSet();

    public void setFile(String fileName) {
        this.file = fileName;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public boolean accept(AuditEvent event) {
        return this.filters.accept(event);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SuppressionFilter suppressionFilter = (SuppressionFilter)obj;
        return Objects.equals(this.filters, suppressionFilter.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @Override
    protected void finishLocalSetup() throws CheckstyleException {
        if (this.file != null) {
            this.filters = this.optional ? (FilterUtils.isFileExists(this.file) ? SuppressionsLoader.loadSuppressions(this.file) : new FilterSet()) : SuppressionsLoader.loadSuppressions(this.file);
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Collections.singleton(this.file);
    }
}

