/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLogStringBundlerCheck
extends BaseFileCheck {
    private final Pattern _logPattern = Pattern.compile("_log\\.(debug|error|fatal|info|trace|warn)\\((.+?)\\);\n", 32);
    private final Pattern _sbPattern = Pattern.compile("^(.*\\+\\s+)?(_?(sb|\\w*SB)([0-9]*)?)(\\w\\+.+)?$", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher1 = this._logPattern.matcher(content);
        while (matcher1.find()) {
            List<String> parametersList;
            String firstParameter;
            Matcher matcher2;
            if (ToolsUtil.isInsideQuotes(content, matcher1.start()) || !(matcher2 = this._sbPattern.matcher(firstParameter = StringUtil.trim((parametersList = JavaSourceUtil.getParameterList(matcher1.group())).get(0)))).find()) continue;
            String sbVariableName = matcher2.group(2);
            String newFirstParameter = StringUtil.replaceFirst(firstParameter, sbVariableName, sbVariableName + ".toString()", matcher2.start(2));
            return StringUtil.replaceFirst(content, firstParameter, newFirstParameter, matcher1.start());
        }
        return content;
    }
}

