/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaModuleComponentCheck
extends BaseJavaTermCheck {
    private final List<String> _allowedClassNames = new ArrayList<String>();

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    public void setAllowedClassNames(String allowedClassNames) {
        Collections.addAll(this._allowedClassNames, StringUtil.split(allowedClassNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        block5: {
            block4: {
                if (this.isSubrepository() || this.isReadOnly(absolutePath)) {
                    return javaTerm.getContent();
                }
                if (javaTerm.getParentJavaClass() != null) {
                    return javaTerm.getContent();
                }
                String packageName = JavaSourceUtil.getPackageName(fileContent);
                if (this._allowedClassNames.contains(packageName + "." + javaTerm.getName())) {
                    return javaTerm.getContent();
                }
                if (!javaTerm.hasAnnotation("Component")) break block4;
                if (!absolutePath.contains("-api/") && !absolutePath.contains("-spi/")) break block5;
                this.addMessage(fileName, "Do not use @Component in '-api' or '-spi' module");
                break block5;
            }
            JavaClass javaClass = (JavaClass)javaTerm;
            for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
                if (!childJavaTerm.hasAnnotation("Reference")) continue;
                this.addMessage(fileName, "@Reference should not be used in a class without @Component");
                break;
            }
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

