/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence.impl;

import com.liferay.counter.service.persistence.impl.CounterFinderImpl;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.util.StringBundler;

public class MultiDataCenterCounterFinderImpl
extends CounterFinderImpl {
    private static final int _BYTE_SHIFTS_MAX = 7;
    private final byte _mostSignificantByte;
    private final int _multiDataCenterBits;

    public MultiDataCenterCounterFinderImpl(int dataCenterCount, int dataCenterDeploymentId) {
        this._multiDataCenterBits = MultiDataCenterCounterFinderImpl.getBits(dataCenterCount - 1);
        if (this._multiDataCenterBits > 7) {
            throw new IllegalArgumentException("Unable to shift more than 8 bits");
        }
        if (MultiDataCenterCounterFinderImpl.getBits(dataCenterDeploymentId) > this._multiDataCenterBits) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Invalid data center count ", String.valueOf(dataCenterCount), " or data center deployment ID ", String.valueOf(dataCenterDeploymentId)}));
        }
        int bits = 7 - this._multiDataCenterBits;
        this._mostSignificantByte = (byte)(dataCenterDeploymentId << bits);
    }

    @Override
    public long increment(String name, int size) {
        return this.getMultiClusterSafeValue(super.increment(name, size));
    }

    protected static int getBits(int value) {
        if (value == 0) {
            return 0;
        }
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    protected long getMultiClusterSafeValue(long value) {
        byte[] bytes = new byte[8];
        BigEndianCodec.putLong((byte[])bytes, (int)0, (long)value);
        int modifiedLeftMostByte = bytes[0] >>> this._multiDataCenterBits;
        bytes[0] = (byte)(modifiedLeftMostByte + this._mostSignificantByte);
        return BigEndianCodec.getLong((byte[])bytes, (int)0);
    }
}

