/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.agent;

import com.liferay.portal.fabric.FabricPathMappingVisitor;
import com.liferay.portal.fabric.InputResource;
import com.liferay.portal.fabric.OutputResource;
import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentProcessCallableExecutor;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerConfig;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerStub;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.fabric.status.FabricStatus;
import com.liferay.portal.fabric.status.RemoteFabricStatus;
import com.liferay.portal.fabric.worker.FabricWorker;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessConfig;
import com.liferay.portal.kernel.util.ObjectGraphUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class NettyFabricAgentStub
implements FabricAgent {
    private final Channel _channel;
    private final AtomicLong _idGenerator = new AtomicLong();
    private final Map<Long, NettyFabricWorkerStub<?>> _nettyFabricWorkerStubs = new ConcurrentHashMap();
    private final Path _remoteRepositoryPath;
    private final Repository<Channel> _repository;
    private final long _rpcRelayTimeout;
    private final Map<Long, DefaultNoticeableFuture<?>> _startupNoticeableFutures = new ConcurrentHashMap();
    private final long _startupTimeout;

    public NettyFabricAgentStub(Channel channel, Repository<Channel> repository, Path remoteRepositoryPath, long rpcRelayTimeout, long startupTimeout) {
        if (channel == null) {
            throw new NullPointerException("Channel is null");
        }
        if (repository == null) {
            throw new NullPointerException("Repository is null");
        }
        if (remoteRepositoryPath == null) {
            throw new NullPointerException("Remote repository path is null");
        }
        this._channel = channel;
        this._repository = repository;
        this._remoteRepositoryPath = remoteRepositoryPath;
        this._rpcRelayTimeout = rpcRelayTimeout;
        this._startupTimeout = startupTimeout;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NettyFabricAgentStub)) {
            return false;
        }
        NettyFabricAgentStub nettyFabricAgentStub = (NettyFabricAgentStub)obj;
        return this._channel.equals(nettyFabricAgentStub._channel);
    }

    @Override
    public <T extends Serializable> FabricWorker<T> execute(ProcessConfig processConfig, ProcessCallable<T> processCallable) {
        final long id = this._idGenerator.getAndIncrement();
        FabricPathMappingVisitor fabricPathMappingVisitor = new FabricPathMappingVisitor(OutputResource.class, this._remoteRepositoryPath, true);
        ObjectGraphUtil.walkObjectGraph(processCallable, (ObjectGraphUtil.Visitor)fabricPathMappingVisitor);
        NettyFabricWorkerStub nettyFabricWorkerStub = new NettyFabricWorkerStub(id, this._channel, this._repository, fabricPathMappingVisitor.getPathMap(), this._rpcRelayTimeout);
        final DefaultNoticeableFuture startupNoticeableFuture = new DefaultNoticeableFuture();
        this._startupNoticeableFutures.put(id, startupNoticeableFuture);
        startupNoticeableFuture.addFutureListener((FutureListener)new FutureListener<Object>(){

            public void complete(Future<Object> future) {
                NettyFabricAgentStub.this._startupNoticeableFutures.remove(id);
            }
        });
        fabricPathMappingVisitor = new FabricPathMappingVisitor(InputResource.class, this._remoteRepositoryPath);
        ObjectGraphUtil.walkObjectGraph(processCallable, (ObjectGraphUtil.Visitor)fabricPathMappingVisitor);
        ChannelFuture channelFuture = this._channel.writeAndFlush(new NettyFabricWorkerConfig<T>(id, processConfig, processCallable, fabricPathMappingVisitor.getPathMap()));
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    return;
                }
                if (channelFuture.isCancelled()) {
                    startupNoticeableFuture.cancel(true);
                    return;
                }
                startupNoticeableFuture.setException(channelFuture.cause());
            }
        });
        final ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                startupNoticeableFuture.cancel(true);
            }
        };
        final ChannelFuture closeChannelFuture = this._channel.closeFuture();
        closeChannelFuture.addListener((GenericFutureListener)channelFutureListener);
        startupNoticeableFuture.addFutureListener((FutureListener)new FutureListener<Object>(){

            public void complete(Future<Object> future) {
                closeChannelFuture.removeListener((GenericFutureListener)channelFutureListener);
            }
        });
        try {
            startupNoticeableFuture.get(this._startupTimeout, TimeUnit.MILLISECONDS);
            this._nettyFabricWorkerStubs.put(id, nettyFabricWorkerStub);
        }
        catch (CancellationException ce) {
            nettyFabricWorkerStub.setCancel();
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                t = t.getCause();
            }
            nettyFabricWorkerStub.setException(t);
        }
        return nettyFabricWorkerStub;
    }

    public void finishStartup(long id) {
        DefaultNoticeableFuture<?> startupNoticeabeFuture = this._startupNoticeableFutures.remove(id);
        if (startupNoticeabeFuture != null) {
            startupNoticeabeFuture.run();
        }
    }

    @Override
    public FabricStatus getFabricStatus() {
        return new RemoteFabricStatus(new NettyFabricAgentProcessCallableExecutor(this._channel));
    }

    @Override
    public Collection<? extends FabricWorker<?>> getFabricWorkers() {
        return Collections.unmodifiableCollection(this._nettyFabricWorkerStubs.values());
    }

    public int hashCode() {
        return this._channel.hashCode();
    }

    public NettyFabricWorkerStub<?> takeNettyStubFabricWorker(long id) {
        return this._nettyFabricWorkerStubs.remove(id);
    }
}

