/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.base.PortletPreferencesServiceBaseImpl;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesServiceImpl
extends PortletPreferencesServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceImpl.class);

    public void deleteArchivedPreferences(long portletItemId) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(portletItemId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)portletItem.getGroupId(), (String)"MANAGE_ARCHIVED_SETUPS");
        long ownerId = portletItemId;
        int ownerType = 5;
        long plid = 0L;
        String portletId = portletItem.getPortletId();
        this.portletPreferencesLocalService.deletePortletPreferences(ownerId, ownerType, plid, portletId);
        this.portletItemLocalService.deletePortletItem(portletItemId);
    }

    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, long portletItemId, PortletPreferences preferences) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(portletItemId);
        this.restoreArchivedPreferences(groupId, layout, portletId, portletItem, preferences);
    }

    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, PortletItem portletItem, PortletPreferences preferences) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (Layout)layout, (String)portletId, (String)"CONFIGURATION");
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, PortletIdCodec.decodePortletName((String)portletId));
        this.copyPreferences(archivedPreferences, preferences);
    }

    public void restoreArchivedPreferences(long groupId, String name, Layout layout, String portletId, PortletPreferences preferences) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        this.restoreArchivedPreferences(groupId, layout, portletId, portletItem, preferences);
    }

    public void updateArchivePreferences(long userId, long groupId, String name, String portletId, PortletPreferences preferences) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)0L, (String)portletId, (String)"CONFIGURATION");
        PortletItem portletItem = this.portletItemLocalService.updatePortletItem(userId, groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, portletId);
        this.copyPreferences(preferences, archivedPreferences);
    }

    protected void copyPreferences(PortletPreferences sourcePreferences, PortletPreferences targetPreferences) {
        try {
            Map targetPreferencesMap = targetPreferences.getMap();
            for (String key : targetPreferencesMap.keySet()) {
                try {
                    targetPreferences.reset(key);
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            Map sourcePreferencesMap = sourcePreferences.getMap();
            for (String key : sourcePreferencesMap.keySet()) {
                try {
                    targetPreferences.setValues(key, sourcePreferences.getValues(key, new String[0]));
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            targetPreferences.store();
        }
        catch (IOException ioe) {
            _log.error((Object)"Unable to copy preferences", (Throwable)ioe);
        }
        catch (ValidatorException ve) {
            throw new SystemException((Throwable)ve);
        }
    }
}

