/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyDB2
extends VerifyProcess {
    @Override
    protected void doVerify() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2) {
            return;
        }
        this.verifyDB2();
    }

    protected void verifyDB2() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select tbname, name, coltype, length from ");
            sb.append("sysibm.syscolumns where tbcreator = (select distinct ");
            sb.append("current schema from sysibm.sysschemata) AND coltype = ");
            sb.append("'VARCHAR' and length = 500");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    if (!this.isPortalTableName(tableName)) continue;
                    String columnName = rs.getString(2);
                    this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " alter column ", columnName, " set data type varchar(600)"}));
                }
            }
        }
    }
}

