/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.VerifyThreadLocal;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;

public class VerifyProcessUtil {
    private static final Log _log = LogFactoryUtil.getLog(VerifyProcessUtil.class);

    public static boolean verifyProcess(boolean ranUpgradeProcess, boolean newBuildNumber, boolean verified) throws VerifyException {
        int verifyFrequency = GetterUtil.getInteger((String)PropsUtil.get("verify.frequency"));
        if (verifyFrequency == -1 || verifyFrequency == 1 && !verified || ranUpgradeProcess || newBuildNumber) {
            return VerifyProcessUtil._verifyProcess(ranUpgradeProcess);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _verifyProcess(boolean ranUpgradeProcess) throws VerifyException {
        boolean ranVerifyProcess = false;
        if (ranUpgradeProcess && PropsValues.INDEX_ON_UPGRADE) {
            PropsUtil.set("index.on.startup", Boolean.TRUE.toString());
            PropsValues.INDEX_ON_STARTUP = true;
        }
        boolean tempIndexReadOnly = IndexWriterHelperUtil.isIndexReadOnly();
        IndexWriterHelperUtil.setIndexReadOnly((boolean)true);
        NotificationThreadLocal.setEnabled((boolean)false);
        StagingAdvicesThreadLocal.setEnabled(false);
        VerifyThreadLocal.setVerifyInProgress((boolean)true);
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            String[] verifyProcessClassNames;
            for (String verifyProcessClassName : verifyProcessClassNames = PropsUtil.getArray("verify.processes")) {
                boolean tempRanVerifyProcess = VerifyProcessUtil._verifyProcess(verifyProcessClassName);
                if (!tempRanVerifyProcess) continue;
                ranVerifyProcess = true;
            }
        }
        finally {
            IndexWriterHelperUtil.setIndexReadOnly((boolean)tempIndexReadOnly);
            NotificationThreadLocal.setEnabled((boolean)true);
            StagingAdvicesThreadLocal.setEnabled(true);
            VerifyThreadLocal.setVerifyInProgress((boolean)false);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
        return ranVerifyProcess;
    }

    private static boolean _verifyProcess(String verifyProcessClassName) throws VerifyException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing verification " + verifyProcessClassName));
        }
        try {
            Class<?> clazz = Class.forName(verifyProcessClassName);
            VerifyProcess verifyProcess = (VerifyProcess)((Object)clazz.newInstance());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running verification " + verifyProcessClassName));
            }
            verifyProcess.verify();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished verification " + verifyProcessClassName));
            }
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            _log.error((Object)(verifyProcessClassName + " cannot be found"));
        }
        catch (IllegalAccessException iae) {
            _log.error((Object)(verifyProcessClassName + " cannot be accessed"));
        }
        catch (InstantiationException ie) {
            _log.error((Object)(verifyProcessClassName + " cannot be initiated"));
        }
        return false;
    }
}

