/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.persistence.AssetLinkFinder;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.impl.AssetLinkImpl;
import com.liferay.portlet.asset.service.persistence.impl.AssetLinkFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Date;
import java.util.List;

public class AssetLinkFinderImpl
extends AssetLinkFinderBaseImpl
implements AssetLinkFinder {
    public static final String FIND_BY_G_C = AssetLinkFinder.class.getName() + ".findByG_C";
    public static final String FIND_BY_C_C = AssetLinkFinder.class.getName() + ".findByC_C";

    public List<AssetLink> findByAssetEntryGroupId(long groupId, int start, int end) {
        return this.findByG_C(groupId, null, null, start, end);
    }

    public List<AssetLink> findByG_C(long groupId, Date startDate, Date endDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C);
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)this._getCreateDateComparator(startDate, endDate));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AssetLink", AssetLinkImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(groupId);
            if (startDate != null) {
                qPos.add(startDate);
            }
            if (endDate != null) {
                qPos.add(endDate);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetLink> findByC_C(long classNameId, long classPK) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_C);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AssetLink", AssetLinkImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(classPK);
            qPos.add(classNameId);
            qPos.add(classPK);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private String _getCreateDateComparator(Date startDate, Date endDate) {
        if (startDate == null && endDate == null) {
            return "";
        }
        String createDateComparator = "";
        if (startDate != null) {
            createDateComparator = " AND (AssetLink.createDate > ?)";
        }
        if (endDate != null) {
            createDateComparator = createDateComparator + " AND (AssetLink.createDate < ?)";
        }
        return createDateComparator;
    }
}

