/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MethodHandler
implements Serializable {
    private final Object[] _arguments;
    private final MethodKey _methodKey;

    public MethodHandler(Method method, Object ... arguments) {
        this(new MethodKey(method), arguments);
    }

    public MethodHandler(MethodKey methodKey, Object ... arguments) {
        this._methodKey = methodKey;
        this._arguments = arguments;
    }

    public Object[] getArguments() {
        Object[] arguments = new Object[this._arguments.length];
        System.arraycopy(this._arguments, 0, arguments, 0, this._arguments.length);
        return arguments;
    }

    public MethodKey getMethodKey() {
        return this._methodKey;
    }

    public Object invoke() throws Exception {
        Method method = this._methodKey.getMethod();
        Object targetObject = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            Class<?> targetClass = this._methodKey.getDeclaringClass();
            targetObject = targetClass.newInstance();
        }
        return method.invoke(targetObject, this._arguments);
    }

    @Deprecated
    public Object invoke(boolean newInstance) throws Exception {
        return this.invoke();
    }

    public Object invoke(Object target) throws Exception {
        Method method = this._methodKey.getMethod();
        return method.invoke(target, this._arguments);
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{arguments=");
        sb.append(Arrays.toString(this._arguments));
        sb.append(", methodKey=");
        sb.append(this._methodKey);
        sb.append("}");
        return sb.toString();
    }
}

