/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.ConcurrentMapperHashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentMapperHashMap<K, IK, V, IV>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    protected transient Set<Map.Entry<K, V>> entrySet;
    protected final ConcurrentMap<IK, IV> innerConcurrentMap;
    protected transient Set<K> keySet;
    protected transient Collection<V> values;
    private static final long serialVersionUID = 1L;

    @Override
    public void clear() {
        this.innerConcurrentMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return this.innerConcurrentMap.containsKey(this.mapKeyForQuery(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return this.innerConcurrentMap.containsValue(this.mapValueForQuery(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnwrapEntrySet(this, null);
        }
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        Object innerValue = this.innerConcurrentMap.get(this.mapKeyForQuery(key));
        if (innerValue == null) {
            return null;
        }
        return this.unmapValueForQuery(innerValue);
    }

    @Override
    public boolean isEmpty() {
        return this.innerConcurrentMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new UnwrapKeySet(this, null);
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKey(key);
        IV oldInnerValue = this.innerConcurrentMap.put(innerKey, this.mapValue(key, value));
        if (oldInnerValue == null) {
            return null;
        }
        this.unmapKey(innerKey);
        return this.unmapValue(oldInnerValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        IV innerValue;
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKey(key);
        IV previousInnerValue = this.innerConcurrentMap.putIfAbsent(innerKey, innerValue = this.mapValue(key, value));
        if (previousInnerValue == null) {
            return null;
        }
        this.unmapKey(innerKey);
        this.unmapValue(innerValue);
        return this.unmapValueForQuery(previousInnerValue);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        Object innerValue = this.innerConcurrentMap.remove(innerKey);
        if (innerValue == null) {
            return null;
        }
        return this.unmapValue(innerValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object previousInnerValue;
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        IV innerValue = this.mapValueForQuery(value);
        if (!innerValue.equals(previousInnerValue = this.innerConcurrentMap.get(innerKey)) || !this.innerConcurrentMap.remove(innerKey, previousInnerValue)) {
            return false;
        }
        this.unmapValue(previousInnerValue);
        return true;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IV newInnerValue = this.mapValue(key, value);
        IV oldInnerValue = this.innerConcurrentMap.replace(this.mapKeyForQuery(key), newInnerValue);
        if (oldInnerValue == null) {
            this.unmapValue(newInnerValue);
            return null;
        }
        return this.unmapValue(oldInnerValue);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (oldValue == null) {
            throw new NullPointerException("Old value is null");
        }
        if (newValue == null) {
            throw new NullPointerException("New value is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        IV newInnerValue = this.mapValue(key, newValue);
        Object oldInnerValue = this.innerConcurrentMap.get(innerKey);
        if (oldInnerValue == null || !oldValue.equals(this.unmapValueForQuery(oldInnerValue))) {
            this.unmapValue(newInnerValue);
            return false;
        }
        if (this.innerConcurrentMap.replace(innerKey, oldInnerValue, newInnerValue)) {
            this.unmapValue(oldInnerValue);
            return true;
        }
        this.unmapValue(newInnerValue);
        return false;
    }

    @Override
    public int size() {
        return this.innerConcurrentMap.size();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new UnwrapValues(this, null);
        }
        return this.values;
    }

    protected ConcurrentMapperHashMap(ConcurrentMap<IK, IV> innerConcurrentMap) {
        this.innerConcurrentMap = innerConcurrentMap;
    }

    protected abstract IK mapKey(K var1);

    protected abstract IK mapKeyForQuery(K var1);

    protected abstract IV mapValue(K var1, V var2);

    protected abstract IV mapValueForQuery(V var1);

    protected abstract K unmapKey(IK var1);

    protected abstract K unmapKeyForQuery(IK var1);

    protected abstract V unmapValue(IV var1);

    protected abstract V unmapValueForQuery(IV var1);
}

