/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;

public class RepositoryConfigurationBuilder {
    private final Collection<RepositoryConfiguration.Parameter> _parameters = new ArrayList<RepositoryConfiguration.Parameter>();
    private final ResourceBundleLoader _resourceBundleLoader;

    public RepositoryConfigurationBuilder() {
        this(LanguageUtil.getPortalResourceBundleLoader(), new String[0]);
    }

    public RepositoryConfigurationBuilder(ResourceBundleLoader resourceBundleLoader, String ... names) {
        this._resourceBundleLoader = resourceBundleLoader;
        for (String name : names) {
            this.addParameter(name);
        }
    }

    public RepositoryConfigurationBuilder addParameter(String name) {
        String labelKey = HtmlUtil.escape(StringUtil.replace(StringUtil.toLowerCase(name), '_', '-'));
        return this.addParameter(name, labelKey);
    }

    public RepositoryConfigurationBuilder addParameter(String labelKey, String name) {
        this._parameters.add(new ParameterImpl(labelKey, name));
        return this;
    }

    public RepositoryConfiguration build() {
        return new RepositoryConfigurationImpl(new ArrayList<RepositoryConfiguration.Parameter>(this._parameters));
    }

    private class ParameterImpl
    implements RepositoryConfiguration.Parameter {
        private final String _labelKey;
        private final String _name;

        public ParameterImpl(String name, String labelKey) {
            this._name = name;
            this._labelKey = labelKey;
        }

        @Override
        public String getLabel(Locale locale) {
            ResourceBundle resourceBundle = RepositoryConfigurationBuilder.this._resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId(locale));
            return LanguageUtil.get(resourceBundle, this._labelKey);
        }

        @Override
        public String getName() {
            return this._name;
        }
    }

    private static class RepositoryConfigurationImpl
    implements RepositoryConfiguration {
        private final Collection<RepositoryConfiguration.Parameter> _parameters;

        public RepositoryConfigurationImpl(Collection<RepositoryConfiguration.Parameter> parameters) {
            this._parameters = parameters;
        }

        @Override
        public Collection<RepositoryConfiguration.Parameter> getParameters() {
            return this._parameters;
        }
    }
}

