/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.OrderByComparator;

public class GroupTypeComparator
extends OrderByComparator<Group> {
    public static final String ORDER_BY_ASC = "groupType ASC, groupName ASC";
    public static final String ORDER_BY_DESC = "groupType DESC, groupName DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"groupType", "groupName"};
    private final boolean _ascending;

    public GroupTypeComparator() {
        this(false);
    }

    public GroupTypeComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Group group1, Group group2) {
        int value = 0;
        if (group1.getType() > group2.getType()) {
            value = 1;
        } else if (group1.getType() < group2.getType()) {
            value = -1;
        }
        if (value == 0) {
            String name1 = group1.getName();
            String name2 = group2.getName();
            value = name1.compareTo(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

