/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.xml;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.CDATA;
import com.liferay.portal.kernel.xml.Comment;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Entity;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.ProcessingInstruction;
import com.liferay.portal.kernel.xml.Text;
import com.liferay.portal.kernel.xml.Visitor;
import java.util.ArrayList;
import java.util.List;

@ProviderType
public abstract class BaseVisitor<T>
implements Visitor<T> {
    @Override
    public T visitAttribute(Attribute attribute) {
        return this.handleAttribute(attribute);
    }

    @Override
    public T visitCDATA(CDATA cdata) {
        return this.handleCDATA(cdata);
    }

    @Override
    public T visitComment(Comment comment) {
        return this.handleComment(comment);
    }

    @Override
    public T visitDocument(Document document) {
        ArrayList nodeResults = new ArrayList(document.nodeCount());
        int size = document.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = document.node(i);
            Object nodeResult = node.accept(this);
            nodeResults.add(nodeResult);
        }
        return (T)this.handleDocument(document, nodeResults);
    }

    @Override
    public T visitElement(Element element) {
        List<Attribute> attributes = element.attributes();
        ArrayList attributeResults = new ArrayList(attributes.size());
        int size = element.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = element.attribute(i);
            Object atrributeResult = attribute.accept(this);
            attributeResults.add(atrributeResult);
        }
        ArrayList nodeResults = new ArrayList(element.nodeCount());
        int size2 = element.nodeCount();
        for (int i = 0; i < size2; ++i) {
            Node node = element.node(i);
            Object nodeResult = node.accept(this);
            if (nodeResult == null) continue;
            nodeResults.add(nodeResult);
        }
        return (T)this.handleElement(element, attributeResults, nodeResults);
    }

    @Override
    public T visitEntity(Entity entity) {
        return this.handleEntity(entity);
    }

    @Override
    public T visitNamespace(Namespace namespace) {
        return this.handleNamespace(namespace);
    }

    @Override
    public T visitNode(Node node) {
        return this.handleNode(node);
    }

    @Override
    public T visitProcessInstruction(ProcessingInstruction processingInstruction) {
        return this.handleProcessInstruction(processingInstruction);
    }

    @Override
    public T visitText(Text text) {
        return this.handleText(text);
    }

    protected abstract T handleAttribute(Attribute var1);

    protected abstract T handleCDATA(CDATA var1);

    protected abstract T handleComment(Comment var1);

    protected abstract T handleDocument(Document var1, List<T> var2);

    protected abstract T handleElement(Element var1, List<T> var2, List<T> var3);

    protected abstract T handleEntity(Entity var1);

    protected abstract T handleNamespace(Namespace var1);

    protected abstract T handleNode(Node var1);

    protected abstract T handleProcessInstruction(ProcessingInstruction var1);

    protected abstract T handleText(Text var1);
}

