/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSignatureStylingCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = javaTerm.getContent();
        String indent = SourceUtil.getIndent(javaTermContent);
        Pattern pattern = Pattern.compile(StringBundler.concat("(", indent, javaTerm.getAccessModifier(), " .*?[;{]\\s*?\n)((\n*)([^\n]+)\n)?"), 32);
        Matcher matcher = pattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return javaTermContent;
        }
        String signature = matcher.group(1);
        String[] signatureLines = StringUtil.splitLines(signature);
        String newLineChars = matcher.group(3);
        String nextLine = StringUtil.trim(matcher.group(4));
        if (signatureLines.length == 1) {
            return this._formatSingleLineSignature(javaTermContent, signature, newLineChars, nextLine);
        }
        return this._formatMultiLinesSignature(javaTermContent, signature, signatureLines, indent, newLineChars, nextLine);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private String _fixLeadingTabs(String content, String line, int expectedTabCount) {
        int leadingTabCount = this.getLeadingTabCount(line);
        String newLine = line;
        while (leadingTabCount != expectedTabCount) {
            if (leadingTabCount > expectedTabCount) {
                newLine = StringUtil.replaceFirst(newLine, '\t', "");
                --leadingTabCount;
                continue;
            }
            newLine = "\t" + newLine;
            ++leadingTabCount;
        }
        return StringUtil.replace(content, line, newLine);
    }

    private String _formatMultiLinesSignature(String javaTermContent, String signature, String[] signatureLines, String indent, String newLineChars, String nextLine) {
        if (signature.endsWith("{\n") && newLineChars != null && newLineChars.length() == 0 && !nextLine.equals("}")) {
            return StringUtil.replace(javaTermContent, signature, signature + "\n");
        }
        int throwsPos = signature.indexOf("\tthrows ");
        String newSignature = signature;
        int expectedTabCount = -1;
        for (int i = 0; i < signatureLines.length; ++i) {
            String line = signatureLines[i];
            if (line.contains(indent + "throws ")) {
                newSignature = this._fixLeadingTabs(newSignature, line, indent.length() + 1);
                break;
            }
            if (expectedTabCount == -1) {
                if (!line.endsWith("(")) continue;
                expectedTabCount = Math.max(this.getLeadingTabCount(line), indent.length()) + 1;
                if (throwsPos == -1 || expectedTabCount != indent.length() + 1) continue;
                ++expectedTabCount;
                continue;
            }
            String previousLine = signatureLines[i - 1];
            newSignature = previousLine.endsWith(",") && this.getLevel(previousLine, "<", ">") <= 0 || previousLine.endsWith("(") ? this._fixLeadingTabs(newSignature, line, expectedTabCount) : this._fixLeadingTabs(newSignature, line, this.getLeadingTabCount(previousLine) + 1);
        }
        if (throwsPos != -1) {
            String throwsExceptions = newSignature.substring(throwsPos + 1);
            String newThrowsExceptions = throwsExceptions.replaceAll("\n\t* *(\\S)", "\n" + indent + "\t\t   $1");
            newSignature = StringUtil.replace(newSignature, throwsExceptions, newThrowsExceptions);
        }
        return StringUtil.replace(javaTermContent, signature, newSignature);
    }

    private String _formatSingleLineSignature(String javaTermContent, String signature, String newLineChars, String nextLine) {
        if (newLineChars != null && newLineChars.length() > 0 && !nextLine.matches("/[/*].*")) {
            return StringUtil.replace(javaTermContent, signature + "\n", signature);
        }
        return javaTermContent;
    }
}

