/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import com.liferay.source.formatter.util.CheckType;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceFormatterSuppressions {
    private final FilterSet _checkstyleFilterSet = new FilterSet();
    private final Map<String, Map<String, List<String>>> _sourceChecksSuppressionsMap = new HashMap<String, Map<String, List<String>>>();

    public void addSuppression(CheckType checkType, String suppressionsFileLocation, String checkName, String fileName) {
        if (checkType.equals((Object)CheckType.SOURCE_CHECK)) {
            this._addSourceCheckSuppression(suppressionsFileLocation, checkName, fileName);
        } else {
            this._addCheckstyleSuppression(checkName, fileName);
        }
    }

    public FilterSet getCheckstyleFilterSet() {
        return this._checkstyleFilterSet;
    }

    public boolean isSuppressed(String sourceCheckName, String absolutePath) {
        Map<String, List<String>> sourceCheckSuppressionsMap = this._sourceChecksSuppressionsMap.get(sourceCheckName);
        if (sourceCheckSuppressionsMap == null) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : sourceCheckSuppressionsMap.entrySet()) {
            String suppressionsFileLocation = entry.getKey();
            if (!absolutePath.startsWith(suppressionsFileLocation)) continue;
            List<String> fileNames = entry.getValue();
            for (String fileName : fileNames) {
                if (!absolutePath.matches(".*" + fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void _addCheckstyleSuppression(String checkName, String fileName) {
        this._checkstyleFilterSet.addFilter((Filter)new SuppressElement(fileName, checkName, null, null, null));
    }

    private void _addSourceCheckSuppression(String suppressionsFileLocation, String checkName, String fileName) {
        List<String> fileNames;
        Map<String, List<String>> sourceCheckSuppressionsMap = this._sourceChecksSuppressionsMap.get(checkName);
        if (sourceCheckSuppressionsMap == null) {
            sourceCheckSuppressionsMap = new HashMap<String, List<String>>();
        }
        if ((fileNames = sourceCheckSuppressionsMap.get(suppressionsFileLocation)) == null) {
            fileNames = new ArrayList<String>();
        }
        fileNames.add(fileName);
        sourceCheckSuppressionsMap.put(suppressionsFileLocation, fileNames);
        this._sourceChecksSuppressionsMap.put(checkName, sourceCheckSuppressionsMap);
    }
}

