/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class AuthTokenWhitelistImpl
extends BaseAuthTokenWhitelist {
    private final Set<String> _originCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());

    public AuthTokenWhitelistImpl() {
        this.trackWhitelistServices("auth.token.ignore.origins", this._originCSRFWhitelist);
        this.registerPortalProperty("auth.token.ignore.origins");
        this.trackWhitelistServices("auth.token.ignore.portlets", this._portletCSRFWhitelist);
        this.registerPortalProperty("auth.token.ignore.portlets");
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist", this._portletInvocationWhitelist);
        this.registerPortalProperty("portlet.add.default.resource.check.whitelist");
    }

    @Deprecated
    public Set<String> getOriginCSRFWhitelist() {
        return this._originCSRFWhitelist;
    }

    @Deprecated
    public Set<String> getPortletCSRFWhitelist() {
        return this._portletCSRFWhitelist;
    }

    @Deprecated
    public Set<String> getPortletInvocationWhitelist() {
        return this._portletInvocationWhitelist;
    }

    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (String whitelistedOrigin : this._originCSRFWhitelist) {
            if (!origin.startsWith(whitelistedOrigin)) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletCSRFWhitelisted(HttpServletRequest request, Portlet portlet) {
        return this._portletCSRFWhitelist.contains(portlet.getRootPortletId());
    }

    public boolean isPortletInvocationWhitelisted(HttpServletRequest request, Portlet portlet) {
        return this._portletInvocationWhitelist.contains(portlet.getPortletId());
    }

    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String rootPortletId = PortletIdCodec.decodePortletName((String)liferayPortletURL.getPortletId());
        return this._portletCSRFWhitelist.contains(rootPortletId);
    }

    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        return this._portletInvocationWhitelist.contains(liferayPortletURL.getPortletId());
    }

    public boolean isValidSharedSecret(String sharedSecret) {
        if (Validator.isNull((String)sharedSecret)) {
            return false;
        }
        if (Validator.isNull((String)PropsValues.AUTH_TOKEN_SHARED_SECRET)) {
            return false;
        }
        return sharedSecret.equals(DigesterUtil.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET));
    }
}

